/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.vecmath.Point3d;
import org.biojava.nbio.structure.Calc;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.cluster.Subunit;
import org.biojava.nbio.structure.cluster.SubunitCluster;
import org.biojava.nbio.structure.cluster.SubunitClusterer;
import org.biojava.nbio.structure.cluster.SubunitClustererParameters;
import org.biojava.nbio.structure.contact.BoundingBox;
import org.biojava.nbio.structure.contact.Grid;
import org.biojava.nbio.structure.symmetry.core.C2RotationSolver;
import org.biojava.nbio.structure.symmetry.core.HelixLayers;
import org.biojava.nbio.structure.symmetry.core.HelixSolver;
import org.biojava.nbio.structure.symmetry.core.QuatSymmetryParameters;
import org.biojava.nbio.structure.symmetry.core.QuatSymmetryResults;
import org.biojava.nbio.structure.symmetry.core.QuatSymmetrySolver;
import org.biojava.nbio.structure.symmetry.core.QuatSymmetrySubunits;
import org.biojava.nbio.structure.symmetry.core.RotationGroup;
import org.biojava.nbio.structure.symmetry.core.RotationSolver;
import org.biojava.nbio.structure.symmetry.core.Stoichiometry;
import org.biojava.nbio.structure.symmetry.core.SymmetryPerceptionMethod;
import org.jgrapht.Graph;
import org.jgrapht.alg.clique.CliqueMinimalSeparatorDecomposition;
import org.jgrapht.graph.AsSubgraph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.SimpleGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuatSymmetryDetector {
    private static final Logger logger = LoggerFactory.getLogger(QuatSymmetryDetector.class);
    private static final double CONTACT_GRAPH_DISTANCE_CUTOFF = 8.0;
    private static final int CONTACT_GRAPH_MIN_CONTACTS = 5;

    private QuatSymmetryDetector() {
    }

    public static QuatSymmetryResults calcGlobalSymmetry(Structure structure, QuatSymmetryParameters symmParams, SubunitClustererParameters clusterParams) {
        Stoichiometry composition = SubunitClusterer.cluster(structure, clusterParams);
        return QuatSymmetryDetector.calcGlobalSymmetry(composition, symmParams);
    }

    public static QuatSymmetryResults calcGlobalSymmetry(List<Subunit> subunits, QuatSymmetryParameters symmParams, SubunitClustererParameters clusterParams) {
        Stoichiometry composition = SubunitClusterer.cluster(subunits, clusterParams);
        return QuatSymmetryDetector.calcGlobalSymmetry(composition, symmParams);
    }

    public static QuatSymmetryResults calcGlobalSymmetry(Stoichiometry composition, QuatSymmetryParameters symmParams) {
        return QuatSymmetryDetector.calcQuatSymmetry(composition, symmParams);
    }

    public static List<QuatSymmetryResults> calcLocalSymmetries(Structure structure, QuatSymmetryParameters symmParams, SubunitClustererParameters clusterParams) {
        Stoichiometry composition = SubunitClusterer.cluster(structure, clusterParams);
        return QuatSymmetryDetector.calcLocalSymmetries(composition, symmParams);
    }

    public static List<QuatSymmetryResults> calcLocalSymmetries(List<Subunit> subunits, QuatSymmetryParameters symmParams, SubunitClustererParameters clusterParams) {
        Stoichiometry composition = SubunitClusterer.cluster(subunits, clusterParams);
        return QuatSymmetryDetector.calcLocalSymmetries(composition, symmParams);
    }

    public static List<QuatSymmetryResults> calcLocalSymmetries(Stoichiometry globalComposition, QuatSymmetryParameters symmParams) {
        HashSet<Set<Integer>> knownCombinations = new HashSet<Set<Integer>>();
        List<SubunitCluster> clusters = globalComposition.getClusters();
        List<SubunitCluster> nontrivialClusters = clusters.stream().filter(cluster -> cluster.size() > 1).collect(Collectors.toList());
        QuatSymmetrySubunits consideredSubunits = new QuatSymmetrySubunits(nontrivialClusters);
        if (consideredSubunits.getSubunitCount() < 2) {
            return new ArrayList<QuatSymmetryResults>();
        }
        Graph<Integer, DefaultEdge> graph = QuatSymmetryDetector.initContactGraph(nontrivialClusters);
        Stoichiometry nontrivialComposition = new Stoichiometry(nontrivialClusters, false);
        ArrayList allSubunitIds = new ArrayList(graph.vertexSet());
        Collections.sort(allSubunitIds);
        List<Integer> allSubunitClusterIds = consideredSubunits.getClusterIds();
        Map<Integer, List<Integer>> clusterIdToSubunitIds = allSubunitIds.stream().collect(Collectors.groupingBy(allSubunitClusterIds::get, Collectors.toList()));
        ArrayList<QuatSymmetryResults> redundantSymmetries = new ArrayList<QuatSymmetryResults>();
        if (clusters.size() > 1) {
            List<QuatSymmetryResults> clusterSymmetries = QuatSymmetryDetector.calcLocalSymmetriesCluster(nontrivialComposition, clusterIdToSubunitIds, symmParams, knownCombinations);
            redundantSymmetries.addAll(clusterSymmetries);
        }
        List<QuatSymmetryResults> graphSymmetries = QuatSymmetryDetector.calcLocalSymmetriesGraph(nontrivialComposition, allSubunitClusterIds, clusterIdToSubunitIds, symmParams, knownCombinations, graph);
        redundantSymmetries.addAll(graphSymmetries);
        List<QuatSymmetryResults> outputSymmetries = redundantSymmetries.stream().filter(a -> redundantSymmetries.stream().noneMatch(b -> a != b && a.isSupersededBy((QuatSymmetryResults)b))).collect(Collectors.toList());
        if (symmParams.isLocalLimitsExceeded(knownCombinations)) {
            logger.warn("Exceeded calculation limits for local symmetry detection. The results may be incomplete.");
        }
        return outputSymmetries;
    }

    private static Graph<Integer, DefaultEdge> initContactGraph(List<SubunitCluster> clusters) {
        SimpleGraph graph = new SimpleGraph(DefaultEdge.class);
        List<Point3d[]> clusterSubunitCoords = clusters.stream().flatMap(c -> c.getSubunits().stream()).map(r -> Calc.atomsToPoints(r.getRepresentativeAtoms())).collect(Collectors.toList());
        for (int i = 0; i < clusterSubunitCoords.size(); ++i) {
            graph.addVertex((Object)i);
        }
        ArrayList boundingBoxes = new ArrayList();
        clusterSubunitCoords.forEach(c -> boundingBoxes.add(new BoundingBox((Point3d[])c)));
        for (int i = 0; i < clusterSubunitCoords.size() - 1; ++i) {
            Point3d[] coords1 = (Point3d[])clusterSubunitCoords.get(i);
            BoundingBox bb1 = (BoundingBox)boundingBoxes.get(i);
            for (int j = i + 1; j < clusterSubunitCoords.size(); ++j) {
                Point3d[] coords2 = (Point3d[])clusterSubunitCoords.get(j);
                BoundingBox bb2 = (BoundingBox)boundingBoxes.get(j);
                Grid grid = new Grid(8.0);
                grid.addCoords(coords1, bb1, coords2, bb2);
                if (grid.getIndicesContacts().size() < 5) continue;
                graph.addEdge((Object)i, (Object)j);
            }
        }
        return graph;
    }

    private static List<QuatSymmetryResults> calcLocalSymmetriesCluster(Stoichiometry nontrivialComposition, Map<Integer, List<Integer>> clusterIdToSubunitIds, QuatSymmetryParameters symmParams, Set<Set<Integer>> knownCombinations) {
        ArrayList<QuatSymmetryResults> clusterSymmetries = new ArrayList<QuatSymmetryResults>();
        for (int i = 0; i < nontrivialComposition.numberOfComponents(); ++i) {
            QuatSymmetryResults localResult = QuatSymmetryDetector.calcQuatSymmetry(nontrivialComposition.getComponent(i), symmParams);
            if (localResult == null || "C1".equals(localResult.getSymmetry())) continue;
            localResult.setLocal(true);
            clusterSymmetries.add(localResult);
            HashSet knownResult = new HashSet(clusterIdToSubunitIds.get(i));
            knownCombinations.add(knownResult);
        }
        Map groupedSymmetries = clusterSymmetries.stream().collect(Collectors.groupingBy(QuatSymmetryResults::getSymmetry, Collectors.groupingBy(QuatSymmetryResults::getSubunitCount, Collectors.toList())));
        for (Map symmetriesByGroup : groupedSymmetries.values()) {
            for (List symmetriesBySubunits : symmetriesByGroup.values()) {
                QuatSymmetryResults localResult;
                Stoichiometry groupComposition = symmetriesBySubunits.stream().map(QuatSymmetryResults::getStoichiometry).reduce(Stoichiometry::combineWith).get();
                if (groupComposition.numberOfComponents() < 2 || (localResult = QuatSymmetryDetector.calcQuatSymmetry(groupComposition, symmParams)) == null || "C1".equals(localResult.getSymmetry())) continue;
                localResult.setLocal(true);
                clusterSymmetries.add(localResult);
                HashSet knownResult = new HashSet();
                for (SubunitCluster cluster : groupComposition.getClusters()) {
                    int i = nontrivialComposition.getClusters().indexOf(cluster);
                    knownResult.addAll(clusterIdToSubunitIds.get(i));
                }
                knownCombinations.add(knownResult);
            }
        }
        return clusterSymmetries;
    }

    private static List<QuatSymmetryResults> calcLocalSymmetriesGraph(Stoichiometry globalComposition, List<Integer> allSubunitClusterIds, Map<Integer, List<Integer>> clusterIdToSubunitIds, QuatSymmetryParameters symmParams, Set<Set<Integer>> knownCombinations, Graph<Integer, DefaultEdge> graph) {
        ArrayList<QuatSymmetryResults> localSymmetries = new ArrayList<QuatSymmetryResults>();
        if (symmParams.isLocalLimitsExceeded(knownCombinations)) {
            return localSymmetries;
        }
        CliqueMinimalSeparatorDecomposition cmsd = new CliqueMinimalSeparatorDecomposition(graph);
        Set graphComponents = cmsd.getAtoms().stream().filter(component -> component.size() > 1).collect(Collectors.toSet());
        graphComponents.removeAll(knownCombinations);
        for (Set graphComponent : graphComponents) {
            QuatSymmetryResults localResult;
            knownCombinations.add(graphComponent);
            ArrayList<Integer> usedSubunitIds = new ArrayList<Integer>(graphComponent);
            Collections.sort(usedSubunitIds);
            Stoichiometry localStoichiometry = QuatSymmetryDetector.trimSubunitClusters(globalComposition, allSubunitClusterIds, clusterIdToSubunitIds, usedSubunitIds);
            if (localStoichiometry.numberOfComponents() == 0) continue;
            HashSet<Integer> usedSubunitIdsSet = new HashSet<Integer>(usedSubunitIds);
            if (!graphComponent.equals(usedSubunitIdsSet)) {
                if (knownCombinations.contains(usedSubunitIdsSet)) continue;
                knownCombinations.add(usedSubunitIdsSet);
            }
            if ((localResult = QuatSymmetryDetector.calcQuatSymmetry(localStoichiometry, symmParams)) != null && !"C1".equals(localResult.getSymmetry())) {
                localResult.setLocal(true);
                localSymmetries.add(localResult);
                continue;
            }
            if (usedSubunitIds.size() < 3) continue;
            for (Integer removeSubunitId : usedSubunitIds) {
                HashSet<Integer> prunedGraphVertices = new HashSet<Integer>(usedSubunitIds);
                prunedGraphVertices.remove(removeSubunitId);
                if (knownCombinations.contains(prunedGraphVertices)) continue;
                knownCombinations.add(prunedGraphVertices);
                AsSubgraph subGraph = new AsSubgraph(graph, prunedGraphVertices);
                List<QuatSymmetryResults> localSubSymmetries = QuatSymmetryDetector.calcLocalSymmetriesGraph(globalComposition, allSubunitClusterIds, clusterIdToSubunitIds, symmParams, knownCombinations, (Graph<Integer, DefaultEdge>)subGraph);
                localSymmetries.addAll(localSubSymmetries);
            }
        }
        return localSymmetries;
    }

    private static Stoichiometry trimSubunitClusters(Stoichiometry globalComposition, List<Integer> allSubunitClusterIds, Map<Integer, List<Integer>> clusterIdToSubunitIds, List<Integer> usedSubunitIds) {
        List<SubunitCluster> globalClusters = globalComposition.getClusters();
        ArrayList<SubunitCluster> localClusters = new ArrayList<SubunitCluster>();
        TreeSet usedClusterIds = usedSubunitIds.stream().map(allSubunitClusterIds::get).distinct().collect(Collectors.toCollection(TreeSet::new));
        for (Integer usedClusterId : usedClusterIds) {
            SubunitCluster originalCluster = globalClusters.get(usedClusterId);
            List<Integer> allSubunitIdsInCluster = clusterIdToSubunitIds.get(usedClusterId);
            int minSUValue = Collections.min(allSubunitIdsInCluster);
            ArrayList<Integer> usedSubunitIdsInCluster = new ArrayList<Integer>(allSubunitIdsInCluster);
            usedSubunitIdsInCluster.retainAll(usedSubunitIds);
            List<Integer> subunitsToRetain = usedSubunitIdsInCluster.stream().map(i -> i - minSUValue).collect(Collectors.toList());
            if (subunitsToRetain.size() > 1) {
                SubunitCluster filteredCluster = new SubunitCluster(originalCluster, subunitsToRetain);
                localClusters.add(filteredCluster);
                continue;
            }
            usedSubunitIds.removeAll(usedSubunitIdsInCluster);
        }
        return new Stoichiometry(localClusters, false);
    }

    private static QuatSymmetryResults calcQuatSymmetry(Stoichiometry composition, QuatSymmetryParameters parameters) {
        HelixSolver hc;
        HelixLayers helixLayers;
        QuatSymmetrySolver solver;
        QuatSymmetrySubunits subunits = new QuatSymmetrySubunits(composition.getClusters());
        if (subunits.getSubunitCount() == 0) {
            return null;
        }
        RotationGroup rotationGroup = null;
        SymmetryPerceptionMethod method = null;
        if (subunits.getFolds().size() == 1) {
            method = SymmetryPerceptionMethod.NO_ROTATION;
            rotationGroup = new RotationGroup();
            rotationGroup.setC1(subunits.getSubunitCount());
        } else if (subunits.getSubunitCount() == 2 && subunits.getFolds().contains(2)) {
            method = SymmetryPerceptionMethod.C2_ROTATION;
            solver = new C2RotationSolver(subunits, parameters);
            rotationGroup = solver.getSymmetryOperations();
        } else {
            method = SymmetryPerceptionMethod.ROTATION;
            solver = new RotationSolver(subunits, parameters);
            rotationGroup = solver.getSymmetryOperations();
        }
        QuatSymmetryResults results = new QuatSymmetryResults(composition, rotationGroup, method);
        String symmetry = results.getSymmetry();
        if (symmetry.startsWith("C") && (helixLayers = (hc = new HelixSolver(subunits, rotationGroup.getOrder(), parameters)).getSymmetryOperations()).size() > 0) {
            double cRmsd = rotationGroup.getScores().getRmsd();
            double hRmsd = helixLayers.getScores().getRmsd();
            double deltaRmsd = hRmsd - cRmsd;
            if ("C1".equals(symmetry) || !"C1".equals(symmetry) && deltaRmsd <= parameters.getHelixRmsdThreshold()) {
                method = SymmetryPerceptionMethod.ROTO_TRANSLATION;
                results = new QuatSymmetryResults(composition, helixLayers, method);
            }
        }
        return results;
    }
}

