/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.ws.alignment.qblast;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import org.biojava.nbio.core.sequence.io.util.IOUtils;
import org.biojava.nbio.core.sequence.template.Compound;
import org.biojava.nbio.core.sequence.template.Sequence;
import org.biojava.nbio.ws.alignment.RemotePairwiseAlignmentOutputProperties;
import org.biojava.nbio.ws.alignment.RemotePairwiseAlignmentProperties;
import org.biojava.nbio.ws.alignment.RemotePairwiseAlignmentService;
import org.biojava.nbio.ws.alignment.qblast.BlastAlignmentParameterEnum;
import org.biojava.nbio.ws.alignment.qblast.BlastJob;
import org.biojava.nbio.ws.alignment.qblast.BlastOutputParameterEnum;
import org.biojava.nbio.ws.alignment.qblast.MapToStringTransformer;

public class NCBIQBlastService
implements RemotePairwiseAlignmentService {
    public static final long WAIT_INCREMENT = 3000L;
    private static final MapToStringTransformer MAP_TO_STRING_TRANSFORMER = new MapToStringTransformer();
    private static final String SERVICE_URL = "http://blast.ncbi.nlm.nih.gov/Blast.cgi";
    private static final String DEFAULT_EMAIL = "anonymous@biojava.org";
    private static final String DEFAULT_TOOL = "biojava3";
    private URL serviceUrl;
    private String email = "anonymous@biojava.org";
    private String tool = "biojava3";
    private Map<String, BlastJob> jobs = new HashMap<String, BlastJob>();

    public NCBIQBlastService() {
        this.init(SERVICE_URL);
    }

    public NCBIQBlastService(String svcUrl) {
        this.init(svcUrl);
    }

    private void init(String svcUrl) {
        try {
            this.serviceUrl = new URL(svcUrl);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("It looks like the URL for remote NCBI BLAST service (" + svcUrl + ") is wrong. Cause: " + e.getMessage(), e);
        }
    }

    public String getRemoteBlastInfo() throws Exception {
        String string;
        OutputStreamWriter writer = null;
        BufferedReader reader = null;
        try {
            String line;
            URLConnection serviceConnection = this.setQBlastServiceProperties(this.serviceUrl.openConnection());
            writer = new OutputStreamWriter(serviceConnection.getOutputStream());
            writer.write("CMD=Info");
            writer.flush();
            reader = new BufferedReader(new InputStreamReader(serviceConnection.getInputStream()));
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                sb.append(line);
                sb.append(System.getProperty("line.separator"));
            }
            string = sb.toString();
        }
        catch (IOException e) {
            try {
                throw new Exception("Impossible to get info from QBlast service at this time. Cause: " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtils.close(reader);
                IOUtils.close(writer);
                throw throwable;
            }
        }
        IOUtils.close((Closeable)reader);
        IOUtils.close((Closeable)writer);
        return string;
    }

    @Override
    public String sendAlignmentRequest(Sequence<Compound> seq, RemotePairwiseAlignmentProperties rpa) throws Exception {
        return this.sendAlignmentRequest(seq.getSequenceAsString(), rpa);
    }

    public String sendAlignmentRequest(int gid, RemotePairwiseAlignmentProperties rpa) throws Exception {
        return this.sendAlignmentRequest(Integer.toString(gid), rpa);
    }

    @Override
    public String sendAlignmentRequest(String query, RemotePairwiseAlignmentProperties alignmentProperties) throws Exception {
        BufferedReader reader;
        OutputStreamWriter writer;
        block14: {
            String line;
            HashMap<String, String> params = new HashMap<String, String>();
            for (String key : alignmentProperties.getAlignmentOptions()) {
                params.put(key, alignmentProperties.getAlignmentOption(key));
            }
            if (query == null || query.isEmpty()) {
                throw new IllegalArgumentException("Impossible to execute QBlast request. The sequence has not been set.");
            }
            if (!params.containsKey(BlastAlignmentParameterEnum.PROGRAM.name())) {
                throw new IllegalArgumentException("Impossible to execute QBlast request. Parameter PROGRAM has not been set.");
            }
            if (!params.containsKey(BlastAlignmentParameterEnum.DATABASE.name())) {
                throw new IllegalArgumentException("Impossible to execute QBlast request. Parameter DATABASE has not been set.");
            }
            params.put(BlastAlignmentParameterEnum.CMD.name(), "Put");
            params.put(BlastAlignmentParameterEnum.QUERY.name(), query);
            params.put(BlastAlignmentParameterEnum.TOOL.name(), this.getTool());
            params.put(BlastAlignmentParameterEnum.EMAIL.name(), this.getEmail());
            String putCmd = MAP_TO_STRING_TRANSFORMER.transform(params);
            writer = null;
            reader = null;
            URLConnection serviceConnection = this.setQBlastServiceProperties(this.serviceUrl.openConnection());
            writer = new OutputStreamWriter(serviceConnection.getOutputStream());
            writer.write(putCmd);
            writer.flush();
            reader = new BufferedReader(new InputStreamReader(serviceConnection.getInputStream()));
            BlastJob job = new BlastJob();
            while ((line = reader.readLine()) != null) {
                if (!line.contains("class=\"error\"") && !line.contains("Message ID#")) {
                    String[] arr;
                    if (line.contains("RID = ")) {
                        arr = line.split("=");
                        job.setId(arr[1].trim());
                    } else if (line.contains("RTOE = ")) {
                        arr = line.split("=");
                        job.setStartTimestamp(System.currentTimeMillis());
                        job.setExpectedExecutionTime(Long.parseLong(arr[1].trim()) * 1000L);
                    }
                    this.jobs.put(job.getId(), job);
                    continue;
                }
                String[] tmp = line.split("</p></li></ul>");
                String[] moreTmp = tmp[0].split("<p class=\"error\">");
                throw new Exception("NCBI QBlast refused this request because: " + moreTmp[1].trim());
            }
            if (job == null || job.getId() == null) break block14;
            String string = job.getId();
            IOUtils.close((Closeable)reader);
            IOUtils.close((Closeable)writer);
            return string;
        }
        try {
            try {
                throw new Exception("Unable to retrieve request ID");
            }
            catch (IOException e) {
                throw new IOException("An error occured submiting sequence to BLAST server. Cause: " + e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            IOUtils.close(reader);
            IOUtils.close(writer);
            throw throwable;
        }
    }

    public boolean isReady(String id) throws Exception {
        return this.isReady(id, 0L);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isReady(String id, long present) throws Exception {
        block11: {
            job = this.jobs.get(id);
            if (job != null) {
                expectedJobFinishTime = job.getStartTimestamp() + job.getExpectedExecutionTime();
                if (System.currentTimeMillis() < expectedJobFinishTime) {
                    return false;
                }
            } else {
                job = new BlastJob();
                job.setId(id);
                job.setStartTimestamp(System.currentTimeMillis());
                job.setExpectedExecutionTime(0L);
            }
            writer = null;
            reader = null;
            try {
                checkRequest = "CMD=Get&RID=" + job.getId() + "&FORMAT_OBJECT=SearchInfo";
                serviceConnection = this.setQBlastServiceProperties(this.serviceUrl.openConnection());
                writer = new OutputStreamWriter(serviceConnection.getOutputStream());
                writer.write(checkRequest);
                writer.flush();
                reader = new BufferedReader(new InputStreamReader(serviceConnection.getInputStream()));
lbl20:
                // 2 sources

                while ((line = reader.readLine()) != null) {
                    if (line.contains("READY")) {
                        this.jobs.put(job.getId(), job);
                        var10_11 = true;
                        break block11;
                    }
                    ** GOTO lbl-1000
                }
                ** GOTO lbl49
            }
            catch (IOException ioe) {
                try {
                    throw new Exception("It is not possible to fetch Blast report from NCBI at this time. Cause: " + ioe.getMessage(), ioe);
                }
                catch (Throwable var11_14) {
                    IOUtils.close(reader);
                    IOUtils.close(writer);
                    throw var11_14;
                }
            }
        }
        IOUtils.close((Closeable)reader);
        IOUtils.close((Closeable)writer);
        return var10_11;
lbl-1000:
        // 1 sources

        {
            if (!line.contains("WAITING")) ** GOTO lbl-1000
            job.setExpectedExecutionTime(job.getExpectedExecutionTime() + 3000L);
            this.jobs.put(job.getId(), job);
            var10_12 = false;
        }
        IOUtils.close((Closeable)reader);
        IOUtils.close((Closeable)writer);
        return var10_12;
lbl-1000:
        // 1 sources

        {
            if (!line.contains("UNKNOWN")) ** GOTO lbl20
            throw new IllegalArgumentException("Unknown request id - no results exist for it. Given id = " + id);
lbl49:
            // 1 sources

            var10_13 = false;
        }
        IOUtils.close((Closeable)reader);
        IOUtils.close((Closeable)writer);
        return var10_13;
    }

    @Override
    public InputStream getAlignmentResults(String id, RemotePairwiseAlignmentOutputProperties outputProperties) throws Exception {
        InputStream inputStream;
        HashMap<String, String> params = new HashMap<String, String>();
        for (String key : outputProperties.getOutputOptions()) {
            params.put(key, outputProperties.getOutputOption(key));
        }
        OutputStreamWriter writer = null;
        while (!this.isReady(id)) {
            Thread.sleep(3100L);
        }
        params.put(BlastAlignmentParameterEnum.CMD.name(), "Get");
        params.put(BlastOutputParameterEnum.RID.name(), id);
        params.put(BlastAlignmentParameterEnum.TOOL.name(), this.getTool());
        params.put(BlastAlignmentParameterEnum.EMAIL.name(), this.getEmail());
        String getCmd = MAP_TO_STRING_TRANSFORMER.transform(params);
        try {
            URLConnection serviceConnection = this.setQBlastServiceProperties(this.serviceUrl.openConnection());
            writer = new OutputStreamWriter(serviceConnection.getOutputStream());
            writer.write(getCmd);
            writer.flush();
            inputStream = serviceConnection.getInputStream();
        }
        catch (IOException ioe) {
            try {
                throw new Exception("It is not possible to fetch Blast report from NCBI at this time. Cause: " + ioe.getMessage(), ioe);
            }
            catch (Throwable throwable) {
                IOUtils.close(writer);
                throw throwable;
            }
        }
        IOUtils.close((Closeable)writer);
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendDeleteRequest(String id) {
        OutputStreamWriter writer = null;
        try {
            String deleteRequest = "CMD=Delete&RID=" + id;
            URLConnection serviceConnection = this.setQBlastServiceProperties(this.serviceUrl.openConnection());
            writer = new OutputStreamWriter(serviceConnection.getOutputStream());
            writer.write(deleteRequest);
            writer.flush();
        }
        catch (IOException iOException) {
            IOUtils.close(writer);
        }
        catch (Throwable throwable) {
            IOUtils.close(writer);
            throw throwable;
        }
        IOUtils.close((Closeable)writer);
    }

    private URLConnection setQBlastServiceProperties(URLConnection conn) {
        conn.setDoOutput(true);
        conn.setUseCaches(false);
        conn.setRequestProperty("User-Agent", "Biojava/NCBIQBlastService");
        conn.setRequestProperty("Connection", "Keep-Alive");
        conn.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
        conn.setRequestProperty("Content-length", "200");
        return conn;
    }

    public void setTool(String tool) {
        this.tool = tool;
    }

    public String getTool() {
        return this.tool;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getEmail() {
        return this.email;
    }
}

