/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.bytecode;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.biojava.utils.bytecode.CodeClass;
import org.biojava.utils.bytecode.CodeException;
import org.biojava.utils.bytecode.CodeField;
import org.biojava.utils.bytecode.CodeGenerator;
import org.biojava.utils.bytecode.CodeMethod;
import org.biojava.utils.bytecode.ConstantPool;
import org.biojava.utils.bytecode.ExceptionMemento;
import org.biojava.utils.bytecode.GeneratedCodeMethod;
import org.biojava.utils.bytecode.IntrospectedCodeClass;
import org.biojava.utils.bytecode.LocalVariable;
import org.biojava.utils.bytecode.MethodRootContext;

public class GeneratedCodeClass
implements CodeClass {
    private String name;
    private CodeClass superClass;
    private List interfaces;
    private int modifiers;
    private Map methods = new HashMap();
    private Map fields = new HashMap();
    private String sourceFile = null;
    private boolean deprecated;

    public GeneratedCodeClass(String name, Class superClass, Class[] interfaces, int modifiers) throws CodeException {
        this.name = name;
        this.modifiers = modifiers;
        this.superClass = IntrospectedCodeClass.forClass(superClass);
        this.interfaces = new ArrayList<Class>(Arrays.asList(interfaces));
        for (Class clazz : this.interfaces) {
            if (clazz.isInterface()) continue;
            throw new CodeException("Attempted to create class implemneting non-interface " + clazz);
        }
    }

    public GeneratedCodeClass(String name, CodeClass superClass, CodeClass[] interfaces, int modifiers) throws CodeException {
        this.name = name;
        this.modifiers = modifiers;
        this.superClass = superClass;
        this.interfaces = new ArrayList<CodeClass>(Arrays.asList(interfaces));
        for (Object obj : this.interfaces) {
            if (obj instanceof CodeClass) continue;
            throw new CodeException("Interface list must contain CodeClass instances");
        }
    }

    public void setSourceFile(String sourceFile) {
        this.sourceFile = sourceFile;
    }

    public String getSourceFile() {
        return this.sourceFile;
    }

    public void setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public List getInterfaces() {
        return Collections.unmodifiableList(this.interfaces);
    }

    public Set getMethods() {
        return this.methods.keySet();
    }

    public Set getMethodsByName(String name) {
        Set all = this.getMethods();
        HashSet<CodeMethod> some = new HashSet<CodeMethod>();
        for (CodeMethod m : all) {
            if (!m.getName().equals(name)) continue;
            some.add(m);
        }
        return some;
    }

    public CodeMethod getConstructor(CodeClass[] args) throws NoSuchMethodException {
        return this.getMethod("<init>", args);
    }

    public CodeMethod getMethod(String name, CodeClass[] args) throws NoSuchMethodException {
        Set poss = this.getMethodsByName(name);
        block0: for (CodeMethod meth : poss) {
            if (meth.numParameters() != args.length) continue;
            for (int j = 0; j < args.length; ++j) {
                if (!meth.getParameterType(j).equals(args[j])) continue block0;
            }
            return meth;
        }
        StringBuffer methodSig = new StringBuffer("Could not find method " + this.getName() + "." + name + "(");
        if (args.length > 0) {
            methodSig.append(args[0].getName());
        }
        for (int i = 1; i < args.length; ++i) {
            methodSig.append(",");
            methodSig.append(args[i].getName());
        }
        methodSig.append(")");
        throw new NoSuchMethodException(methodSig.toString());
    }

    public Set getFields() {
        return this.fields.keySet();
    }

    public CodeClass getSuperClass() {
        return this.superClass;
    }

    public CodeField getFieldByName(String name) throws NoSuchFieldException {
        CodeField f = (CodeField)this.fields.get(name);
        if (f == null) {
            throw new NoSuchFieldException("No field for " + name + " in class " + this.getName());
        }
        return f;
    }

    public String getName() {
        return this.name;
    }

    public String getJName() {
        String name = this.getName();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == '.') {
                sb.append('/');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public String getDescriptor() {
        String name = this.getName();
        StringBuffer sb = new StringBuffer();
        sb.append('L');
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == '.') {
                sb.append('/');
                continue;
            }
            sb.append(c);
        }
        sb.append(';');
        return sb.toString();
    }

    public GeneratedCodeMethod createMethod(String name, CodeClass type, CodeClass[] args, String[] argNames, int mods) throws CodeException {
        GeneratedCodeMethod cm = new GeneratedCodeMethod(this, name, type, args, argNames, mods);
        if (this.methods.containsKey(cm)) {
            throw new CodeException("Attempt to create multiple methods with same signatures.");
        }
        this.methods.put(cm, null);
        return cm;
    }

    public GeneratedCodeMethod createMethod(String name, CodeClass type, CodeClass[] args, int mods) throws CodeException {
        return this.createMethod(name, type, args, new String[0], mods);
    }

    public CodeField createField(String name, CodeClass clazz, int mods) throws CodeException {
        if (this.fields.containsKey(name)) {
            throw new CodeException("Attempt to create multiple fields named " + name);
        }
        CodeField cf = new CodeField(this, name, clazz, mods);
        this.fields.put(name, cf);
        return cf;
    }

    public void setCodeGenerator(CodeMethod method, CodeGenerator cg) throws CodeException {
        if (!this.methods.containsKey(method)) {
            throw new CodeException("Class doesn't provide method " + method.getName());
        }
        this.methods.put(method, cg);
    }

    public void createCode(OutputStream os) throws IOException, CodeException {
        DataOutputStream dos = new DataOutputStream(os);
        dos.writeInt(-889275714);
        dos.writeShort(3);
        dos.writeShort(45);
        ConstantPool cp = new ConstantPool();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream bdos = new DataOutputStream(baos);
        bdos.writeShort(this.modifiers);
        bdos.writeShort(cp.resolveClass(this));
        bdos.writeShort(cp.resolveClass(this.superClass));
        bdos.writeShort(this.interfaces.size());
        Iterator<Object> i = this.interfaces.iterator();
        while (i.hasNext()) {
            bdos.writeShort(cp.resolveClass((CodeClass)i.next()));
        }
        bdos.writeShort(this.fields.size());
        for (CodeField cf : this.fields.values()) {
            bdos.writeShort(cf.getModifiers());
            bdos.writeShort(cp.resolveUtf8(cf.getName()));
            bdos.writeShort(cp.resolveUtf8(cf.getType().getDescriptor()));
            bdos.writeShort(0);
        }
        Set methSet = this.methods.entrySet();
        bdos.writeShort(methSet.size());
        for (Map.Entry me : methSet) {
            GeneratedCodeMethod cm = (GeneratedCodeMethod)me.getKey();
            CodeGenerator cg = (CodeGenerator)me.getValue();
            bdos.writeShort(cm.getModifiers());
            bdos.writeShort(cp.resolveUtf8(cm.getName()));
            bdos.writeShort(cp.resolveUtf8(cm.getDescriptor()));
            MethodRootContext ctx = new MethodRootContext(this, cm, cp);
            ctx.open();
            LocalVariable thisP = cm.getThis();
            if (thisP != null) {
                ctx.resolveLocal(thisP);
            }
            for (int parm = 0; parm < cm.numParameters(); ++parm) {
                ctx.resolveLocal(cm.getVariable(parm));
            }
            cg.writeCode(ctx);
            ctx.close();
            Set thrownExceptions = cm.getThrownExceptions();
            int numMethAttrs = 1;
            if (!thrownExceptions.isEmpty()) {
                ++numMethAttrs;
            }
            bdos.writeShort(numMethAttrs);
            List exceptionTable = ctx.getExceptionTable();
            bdos.writeShort(cp.resolveUtf8("Code"));
            bdos.writeInt(12 + ctx.getOffset() + exceptionTable.size() * 8);
            bdos.writeShort(cg.stackDepth());
            bdos.writeShort(ctx.getMaxLocals());
            bdos.writeInt(ctx.getOffset());
            ctx.writeTo(bdos);
            bdos.writeShort(exceptionTable.size());
            for (ExceptionMemento em : exceptionTable) {
                if (!em.isFullyResolved()) {
                    throw new CodeException("Exception table entry refers to unresolved label");
                }
                bdos.writeShort(em.startHandled.getOffset());
                bdos.writeShort(em.endHandled.getOffset());
                bdos.writeShort(em.handler.getOffset());
                if (em.eClass != null) {
                    bdos.writeShort(cp.resolveClass(em.eClass));
                    continue;
                }
                bdos.writeShort(0);
            }
            bdos.writeShort(0);
            if (thrownExceptions.size() <= 0) continue;
            bdos.writeShort(cp.resolveUtf8("Exceptions"));
            bdos.writeInt(2 + thrownExceptions.size() * 2);
            bdos.writeShort(thrownExceptions.size());
            for (CodeClass exClass : thrownExceptions) {
                bdos.writeShort(cp.resolveClass(exClass));
            }
        }
        int classAttributes = 0;
        if (this.sourceFile != null) {
            ++classAttributes;
        }
        if (this.deprecated) {
            ++classAttributes;
        }
        bdos.writeShort(classAttributes);
        if (this.sourceFile != null) {
            bdos.writeShort(cp.resolveUtf8("SourceFile"));
            bdos.writeInt(2);
            bdos.writeShort(cp.resolveUtf8(this.sourceFile));
        }
        if (this.isDeprecated()) {
            bdos.writeShort(cp.resolveUtf8("Deprecated"));
            bdos.writeInt(0);
        }
        dos.writeShort(cp.constantPoolSize());
        cp.writeConstantPool(dos);
        baos.writeTo(dos);
    }

    public boolean isPrimitive() {
        return false;
    }

    public boolean isArray() {
        return false;
    }
}

