/**
 * asadmin-glassfish-plugin : a maven plugin for glassfish administratives tasks
 *
 * Copyright (C) 2008  Paul Merlin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.n0pe.asadmin.commands;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.n0pe.asadmin.AbstractAsAdminCmd;
import org.n0pe.asadmin.Util;

/**
 * Configuration provider for AsAdmin.
 *
 * @author Christophe Souvignier <chris.so@free.fr>
 */
public class CreateJdbcConnectionPool extends  AbstractAsAdminCmd {

    public static final String JDBC = "create-jdbc-connection-pool";

    public static final String DATA_SOURCE_OPT = "--datasourceclassname";
    public static final String RESTYPE_OPT = "--restype";
    public static final String PROPERTY_OPT = "--property";

    private String poolName;
    private String dataSource;
    private String restype;
    private Map properties;




    /**
     * CreateJdbcConnectionPool default constructor.
     */
    private CreateJdbcConnectionPool() {
    }

    public CreateJdbcConnectionPool(String poolName) {
        this.poolName = poolName;
    }

    public CreateJdbcConnectionPool withDataSource(String dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    public CreateJdbcConnectionPool withRestype(String restype) {
        this.restype = restype;
        return this;
    }

    public CreateJdbcConnectionPool addProperty(String key, String value) {
        if (properties == null) {
            properties = new HashMap();
        }
        properties.put(key, value);
        return this;
    }


    public boolean needCredentials() {
        return true;
    }

    public String getActionCommand() {
        if (poolName == null) {
            throw new IllegalStateException();
        }
        return JDBC;
    }

    public String[] getParameters() {
       if ((dataSource == null) || (restype == null)) {
            throw new IllegalStateException();
        }
        final String[] params;
        if (properties != null && !properties.isEmpty()) {
            final StringBuffer sw = new StringBuffer();
            String key;
            for (final Iterator it = properties.keySet().iterator(); it.hasNext();) {
                key = (String) it.next();
                sw.append(key).append("=").append(Util.quoteCommandArgument((String) properties.get(key)));
                if (it.hasNext()) {
                    sw.append(":");
                }
            }
            params = new String[]{DATA_SOURCE_OPT, dataSource, RESTYPE_OPT, restype, PROPERTY_OPT, sw.toString(), poolName};

        } else {
            params = new String[]{DATA_SOURCE_OPT, dataSource, RESTYPE_OPT, restype, poolName};
        }
        return params;
    }
}
