/*
 * Decompiled with CFR 0.152.
 */
package org.n0pe.asadmin.commands;

import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.n0pe.asadmin.AbstractAsAdminCmd;

public class Deployment
extends AbstractAsAdminCmd {
    public static final String DEPLOY = "deploy";
    public static final String UNDEPLOY = "undeploy";
    public static final String FORCE_OPT = "--force";
    public static final String CONTEXTROOT_OPT = "--contextroot";
    public static final String NAME_OPT = "--name";
    public static final String TARGET_OPT = "--target";
    private static final int DEPLOY_MODE = 1;
    private static final int UNDEPLOY_MODE = 2;
    private int ACTION = -1;
    private String archive;
    private String component;
    private String contextRoot;
    private String appName;
    private String target;
    private boolean force;

    public Deployment deploy() {
        this.ACTION = 1;
        return this;
    }

    public Deployment undeploy() {
        this.ACTION = 2;
        return this;
    }

    public Deployment archive(String archive) {
        this.archive = archive;
        return this;
    }

    public Deployment component(String component) {
        this.component = component;
        return this;
    }

    public Deployment withContextRoot(String contextRoot) {
        this.contextRoot = contextRoot;
        return this;
    }

    public Deployment force(boolean force) {
        this.force = force;
        return this;
    }

    public Deployment appName(String appName) {
        this.appName = appName;
        return this;
    }

    public Deployment target(String target) {
        this.target = target;
        return this;
    }

    @Override
    public boolean needCredentials() {
        return true;
    }

    @Override
    public String getActionCommand() {
        if (this.ACTION == 1) {
            return DEPLOY;
        }
        if (this.ACTION == 2) {
            return UNDEPLOY;
        }
        throw new IllegalStateException();
    }

    @Override
    public String[] getParameters() {
        ArrayList<String> parameters = new ArrayList<String>();
        if (!StringUtils.isEmpty((String)this.target)) {
            parameters.add(TARGET_OPT);
            parameters.add(this.target);
        }
        if (this.ACTION == 1) {
            if (this.archive == null) {
                throw new IllegalStateException("Cannot deploy without an archive");
            }
            if (this.force) {
                parameters.add(FORCE_OPT);
            }
            if (!StringUtils.isEmpty((String)this.contextRoot)) {
                parameters.add(CONTEXTROOT_OPT);
                parameters.add(this.contextRoot);
            }
            if (!StringUtils.isEmpty((String)this.appName)) {
                parameters.add(NAME_OPT);
                parameters.add(this.appName);
            }
            parameters.add(this.archive);
        } else if (this.ACTION == 2) {
            if (this.component == null) {
                throw new IllegalStateException("Cannot undeploy without a component");
            }
            parameters.add(this.component);
        } else {
            throw new IllegalStateException("No action given");
        }
        return parameters.toArray(new String[parameters.size()]);
    }
}

