/*
 * Decompiled with CFR 0.152.
 */
package org.codeartisans.java.toolbox.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public final class IO {
    public static final int DEFAULT_BUFFER_SIZE = 4096;

    public static void copy(Reader input, Writer output) throws IOException {
        char[] buffer = new char[4096];
        int reads = 1;
        while ((reads = input.read(buffer)) != -1) {
            output.write(buffer, 0, reads);
        }
        output.flush();
    }

    public static void closeSilently(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeSilently(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static void closeSilently(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static void closeSilently(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private IO() {
    }
}

