/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.cargo.container.internal.util.JdkUtils;
import org.codehaus.cargo.util.CargoException;

public class EmbeddedContainerClasspathResolver {
    private static final Map dependencies = new HashMap();
    private JdkUtils jdkUtils = new JdkUtils();

    public ClassLoader resolveDependencies(String containerId, String containerHome) throws FileNotFoundException {
        URLClassLoader classloader;
        List depList = (List)dependencies.get(containerId);
        if (depList == null) {
            return null;
        }
        try {
            ArrayList<URL> urls = new ArrayList<URL>();
            if (containerId.equals("jetty7x")) {
                String xerces = System.getProperty("cargo.testdata.xerces-jars");
                if (xerces == null) {
                    throw new IllegalArgumentException("cargo.testdata.xerces-jars not defined");
                }
                File[] xercesJARs = new File(xerces).listFiles();
                if (xercesJARs == null) {
                    throw new FileNotFoundException("Directory not found: " + xerces);
                }
                for (File xercesJAR : xercesJARs) {
                    urls.add(xercesJAR.toURI().toURL());
                }
            }
            for (String dependencyRelativePath : depList) {
                if (dependencyRelativePath.endsWith("*.jar")) {
                    File folder = new File(containerHome, dependencyRelativePath).getParentFile();
                    File[] jars = folder.listFiles(new FilenameFilter(){

                        public boolean accept(File dir, String name) {
                            return name.endsWith(".jar");
                        }
                    });
                    if (jars == null) {
                        throw new FileNotFoundException("No files matched: " + folder.toString() + "/*.jar");
                    }
                    for (int i = 0; i < jars.length; ++i) {
                        urls.add(jars[i].toURI().toURL());
                    }
                    continue;
                }
                File dependencyPath = new File(containerHome, dependencyRelativePath);
                urls.add(dependencyPath.toURI().toURL());
            }
            if (!this.jdkUtils.isOSX()) {
                urls.add(this.jdkUtils.getToolsJar().toURI().toURL());
            }
            classloader = null;
            if (containerId.equals("tomcat5x")) {
                classloader = new URLClassLoader(new URL[0], this.getClass().getClassLoader()){

                    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
                        if (name.startsWith("org.apache.tools.ant")) {
                            throw new ClassNotFoundException();
                        }
                        return super.loadClass(name, resolve);
                    }
                };
            }
            classloader = new URLClassLoader(urls.toArray(new URL[0]), (ClassLoader)classloader);
        }
        catch (MalformedURLException e) {
            throw new CargoException("Failed to resolve dependency", (Throwable)e);
        }
        return classloader;
    }

    static {
        ArrayList<String> jetty4xDependencies = new ArrayList<String>();
        jetty4xDependencies.add("lib/*.jar");
        jetty4xDependencies.add("ext/*.jar");
        ArrayList<String> jetty5xDependencies = new ArrayList<String>();
        jetty5xDependencies.add("lib/*.jar");
        jetty5xDependencies.add("ext/*.jar");
        ArrayList<String> jetty6xDependencies = new ArrayList<String>();
        jetty6xDependencies.add("lib/*.jar");
        jetty6xDependencies.add("lib/jsp-2.0/*.jar");
        jetty6xDependencies.add("lib/management/*.jar");
        jetty6xDependencies.add("lib/naming/*.jar");
        jetty6xDependencies.add("lib/plus/*.jar");
        jetty6xDependencies.add("lib/xbean/*.jar");
        ArrayList<String> jetty7xDependencies = new ArrayList<String>();
        jetty7xDependencies.add("lib/*.jar");
        jetty7xDependencies.add("lib/jndi/*.jar");
        jetty7xDependencies.add("lib/jsp/*.jar");
        ArrayList<String> tomcat5xDependencies = new ArrayList<String>();
        tomcat5xDependencies.add("bin/*.jar");
        tomcat5xDependencies.add("common/lib/*.jar");
        tomcat5xDependencies.add("server/lib/*.jar");
        dependencies.put("jetty4x", jetty4xDependencies);
        dependencies.put("jetty5x", jetty5xDependencies);
        dependencies.put("jetty6x", jetty6xDependencies);
        dependencies.put("jetty7x", jetty7xDependencies);
        dependencies.put("tomcat5x", tomcat5xDependencies);
    }
}

