/*
 * ========================================================================
 *
 * Codehaus CARGO, copyright 2004-2010 Vincent Massol.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * ========================================================================
 */
package org.codehaus.cargo.sample.java.validator;

import org.codehaus.cargo.container.ContainerType;

/**
 * Validate that a container id starts with a specific value.
 *
 * @version $Id: StartsWithContainerValidator.java 2335 2010-07-01 23:35:19Z alitokmen $
 */
public class StartsWithContainerValidator implements Validator
{
    private String containerIdPrefix;

    public StartsWithContainerValidator(String containerIdPrefix)
    {
        this.containerIdPrefix = containerIdPrefix;
    }

    /**
     * @return true if the container id starts with the passed container id prefix, false otherwise
     */
    public boolean validate(String containerId, ContainerType type)
    {
        return containerId.startsWith(this.containerIdPrefix);
    }
}
