/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.generic.DefaultContainerFactory;
import org.codehaus.cargo.sample.java.EnvironmentTestData;
import org.codehaus.cargo.sample.java.validator.Validator;

public class CargoTestSuite
extends TestSuite {
    private static final String SYSTEM_PROPERTY_CONTAINER_IDS = "cargo.containers";
    private Map registeredContainers;
    private List containerIds;

    public CargoTestSuite(String suiteName) {
        super(suiteName);
        this.initialize();
    }

    private void initialize() {
        this.registeredContainers = new DefaultContainerFactory().getContainerIds();
        this.containerIds = new ArrayList();
        if (System.getProperty(SYSTEM_PROPERTY_CONTAINER_IDS) == null) {
            throw new RuntimeException("System property \"cargo.containers\" must be defined.");
        }
        StringTokenizer tokens = new StringTokenizer(System.getProperty(SYSTEM_PROPERTY_CONTAINER_IDS), ", ");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            this.containerIds.add(token);
        }
    }

    public void addTestSuite(Class testClass, Validator[] validators) {
        this.addTestSuite(testClass, validators, null);
    }

    public void addTestSuite(Class testClass, Validator[] validators, Set excludedContainerIds) {
        for (String containerId : this.containerIds) {
            if (excludedContainerIds != null && excludedContainerIds.contains(containerId)) continue;
            Set registeredTypes = (Set)this.registeredContainers.get(containerId);
            if (registeredTypes == null) {
                throw new RuntimeException("Invalid container id [" + containerId + "]");
            }
            for (ContainerType type : registeredTypes) {
                boolean shouldAddTest = true;
                for (int i = 0; i < validators.length; ++i) {
                    if (validators[i].validate(containerId, type)) continue;
                    shouldAddTest = false;
                    break;
                }
                if (!shouldAddTest) continue;
                try {
                    this.addContainerToSuite(containerId, type, testClass);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to add container [" + containerId + "] for test case class [" + testClass.getName() + "]", e);
                }
            }
        }
    }

    private void addContainerToSuite(String containerId, ContainerType type, Class testClass) throws Exception {
        Method[] methods;
        for (Method method : methods = testClass.getMethods()) {
            if (!method.getName().startsWith("test")) continue;
            this.addContainerToTest(containerId, type, method.getName(), testClass);
        }
    }

    private void addContainerToTest(String containerId, ContainerType type, String testName, Class testClass) throws Exception {
        String testClassName = testClass.getName().substring(testClass.getName().lastIndexOf(".") + 1);
        String targetDir = containerId + "/" + type.getType() + "/" + testClassName + "/" + testName + "/container";
        EnvironmentTestData testData = new EnvironmentTestData(containerId, type, targetDir);
        Constructor constructor = testClass.getConstructor(String.class, EnvironmentTestData.class);
        Test test = (Test)constructor.newInstance(testName, testData);
        this.addTest(test);
    }
}

