/*
 * ========================================================================
 *
 * Copyright 2006 Vincent Massol.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * ========================================================================
 */
package org.codehaus.cargo.sample.java.validator;

import org.codehaus.cargo.generic.configuration.ConfigurationFactory;
import org.codehaus.cargo.generic.configuration.DefaultConfigurationFactory;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.configuration.ConfigurationType;

/**
 * Validate that a container has a runtime configuration.
 *
 * @version $Id: HasRuntimeConfigurationValidator.java 1705 2008-09-02 13:14:55Z adriana $
 */
public class HasRuntimeConfigurationValidator implements Validator
{
    private ConfigurationFactory factory = new DefaultConfigurationFactory();

    /**
     * @return true if the container has a runtime configuration implementation available,
     *         false otherwise
     */
    public boolean validate(String containerId, ContainerType type)
    {
        return this.factory.isConfigurationRegistered(containerId, type, ConfigurationType.RUNTIME);
    }
}
