/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.installer.Proxy;

public class EnvironmentTestData {
    public String containerId;
    public ContainerType containerType;
    public URL installURL;
    public String installDir;
    public int port;
    public long containerTimeout;
    public String targetDir;
    public String home;
    public String javaHome;
    public String version;
    public Proxy proxy;

    public EnvironmentTestData(String containerId, ContainerType containerType, String targetDirSuffix) {
        this.containerId = containerId;
        this.containerType = containerType;
        this.targetDir = new File(this.getFileFromString(this.getSystemProperty("cargo.target.dir")), targetDirSuffix).getPath();
        this.installDir = this.getSystemProperty("cargo.install.dir");
        this.proxy = this.createProxyElement();
        this.installURL = this.createInstallURL(containerId);
        this.port = this.createPort(containerId);
        this.home = this.getSystemProperty("cargo." + containerId + ".home");
        this.javaHome = this.getSystemProperty("cargo." + containerId + ".java.home");
        this.version = System.getProperty("cargo.version");
        this.containerTimeout = Long.parseLong(this.getSystemProperty("cargo.containers.timeout"));
    }

    private int createPort(String containerName) {
        String portString = this.getSystemProperty("cargo." + containerName + ".port");
        return Integer.parseInt(portString);
    }

    private URL createInstallURL(String containerName) {
        URL installURL = null;
        String url = this.getSystemProperty("cargo." + containerName + ".url");
        if (url != null) {
            try {
                installURL = new URL(url);
            }
            catch (MalformedURLException e) {
                throw new ContainerException("invalid install URL [" + url + "]", (Throwable)e);
            }
        }
        return installURL;
    }

    private String getSystemProperty(String name) {
        String result = System.getProperty(name);
        if (result == null || result.length() == 0) {
            result = null;
        }
        return result;
    }

    private String getSystemProperty(String name, String defaultValue) {
        String result = System.getProperty(name);
        return result == null || result.length() == 0 ? defaultValue : result;
    }

    private File getFileFromString(String fileName) {
        File result = null;
        if (fileName != null) {
            result = new File(fileName);
        }
        return result;
    }

    private Proxy createProxyElement() {
        String proxyHost = this.getSystemProperty("cargo.proxy.host");
        String proxyPort = this.getSystemProperty("cargo.proxy.port", "80");
        String proxyUser = this.getSystemProperty("cargo.proxy.user");
        String proxyPassword = System.getProperty("cargo.proxy.password");
        String proxyExcludeHosts = this.getSystemProperty("cargo.proxy.excludehosts", "");
        Proxy proxy = null;
        if (proxyHost != null) {
            proxy = new Proxy();
            proxy.setHost(proxyHost);
            proxy.setPort(Integer.parseInt(proxyPort));
            if (proxyUser != null) {
                proxy.setUser(proxyUser);
                proxy.setPassword(proxyPassword);
            }
            proxy.setExcludeHosts(proxyExcludeHosts);
        }
        return proxy;
    }

    public String getTestDataFileFor(String artifactName) {
        String localMavenRepository = System.getProperty("localRepository");
        String location = System.getProperty("cargo.testdata." + artifactName);
        if (location == null) {
            throw new ContainerException("Test data artifact not found [" + artifactName + "] under base directory [" + localMavenRepository + "]");
        }
        return new File(localMavenRepository, location).getPath();
    }
}

