/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.cargo.container.internal.util.JdkUtils;
import org.codehaus.cargo.util.CargoException;

public class JettyClasspathResolver {
    private Map jettyDependencies = new HashMap();
    private JdkUtils jdkUtils = new JdkUtils();

    public JettyClasspathResolver() {
        ArrayList<String> jetty4xDependencies = new ArrayList<String>();
        jetty4xDependencies.add("lib/javax.servlet.jar");
        jetty4xDependencies.add("lib/org.mortbay.jmx.jar");
        jetty4xDependencies.add("lib/org.mortbay.jetty.jar");
        jetty4xDependencies.add("ext/jasper-compiler.jar");
        jetty4xDependencies.add("ext/jasper-runtime.jar");
        jetty4xDependencies.add("ext/ant.jar");
        jetty4xDependencies.add("ext/ant-launcher.jar");
        jetty4xDependencies.add("ext/jcert.jar");
        jetty4xDependencies.add("ext/jmxri.jar");
        jetty4xDependencies.add("ext/jmxtools.jar");
        jetty4xDependencies.add("ext/jnet.jar");
        jetty4xDependencies.add("ext/jsse.jar");
        jetty4xDependencies.add("ext/xercesImpl.jar");
        jetty4xDependencies.add("ext/xml-apis.jar");
        ArrayList<String> jetty5xDependencies = new ArrayList<String>();
        jetty5xDependencies.add("lib/javax.servlet.jar");
        jetty5xDependencies.add("lib/org.mortbay.jetty.jar");
        jetty5xDependencies.add("lib/org.mortbay.jmx.jar");
        jetty5xDependencies.add("ext/ant.jar");
        jetty5xDependencies.add("ext/commons-el.jar");
        jetty5xDependencies.add("ext/jasper-compiler.jar");
        jetty5xDependencies.add("ext/jasper-runtime.jar");
        jetty5xDependencies.add("ext/commons-logging.jar");
        jetty5xDependencies.add("ext/mx4j.jar");
        jetty5xDependencies.add("ext/mx4j-remote.jar");
        jetty5xDependencies.add("ext/mx4j-tools.jar");
        jetty5xDependencies.add("ext/xercesImpl.jar");
        jetty5xDependencies.add("ext/xml-apis.jar");
        jetty5xDependencies.add("ext/xmlParserAPIs.jar");
        ArrayList<String> jetty6xDependencies = new ArrayList<String>();
        jetty6xDependencies.add("lib/jetty.jar");
        jetty6xDependencies.add("lib/jetty-util.jar");
        jetty6xDependencies.add("lib/servlet-api-2.5.jar");
        jetty6xDependencies.add("lib/jsp-2.0/jsp-api-2.0.jar");
        jetty6xDependencies.add("lib/jsp-2.0/jasper-compiler-jdt-5.5.15.jar");
        jetty6xDependencies.add("lib/jsp-2.0/jasper-compiler-5.5.15.jar");
        jetty6xDependencies.add("lib/jsp-2.0/jasper-runtime-5.5.15.jar");
        jetty6xDependencies.add("lib/jsp-2.0/xercesImpl-2.6.2.jar");
        jetty6xDependencies.add("lib/jsp-2.0/xmlParserAPIs-2.6.2.jar");
        jetty6xDependencies.add("lib/jsp-2.0/commons-el-1.0.jar");
        jetty6xDependencies.add("lib/jsp-2.0/jcl104-over-slf4j-1.0-rc5.jar");
        jetty6xDependencies.add("lib/jsp-2.0/slf4j-simple-1.0-rc5.jar");
        jetty6xDependencies.add("lib/management/jetty-management.jar");
        jetty6xDependencies.add("lib/management/mx4j-3.0.1.jar");
        jetty6xDependencies.add("lib/management/mx4j-tools-2.1.1.jar");
        jetty6xDependencies.add("lib/naming/jetty-naming.jar");
        jetty6xDependencies.add("lib/plus/jetty-plus.jar");
        jetty6xDependencies.add("lib/xbean/jetty-xbean.jar");
        ArrayList<String> jetty7xDependencies = new ArrayList<String>();
        jetty7xDependencies.add("lib/jetty.jar");
        jetty7xDependencies.add("lib/jetty-util.jar");
        jetty7xDependencies.add("lib/servlet-api-2.5.jar");
        jetty7xDependencies.add("lib/jsp-2.0/jsp-api-2.0.jar");
        jetty7xDependencies.add("lib/jsp-2.0/jasper-compiler-jdt-5.5.15.jar");
        jetty7xDependencies.add("lib/jsp-2.0/jasper-compiler-5.5.15.jar");
        jetty7xDependencies.add("lib/jsp-2.0/jasper-runtime-5.5.15.jar");
        jetty7xDependencies.add("lib/jsp-2.0/xercesImpl-2.6.2.jar");
        jetty7xDependencies.add("lib/jsp-2.0/xmlParserAPIs-2.6.2.jar");
        jetty7xDependencies.add("lib/jsp-2.0/commons-el-1.0.jar");
        jetty7xDependencies.add("lib/jsp-2.0/jcl104-over-slf4j-1.0-rc5.jar");
        jetty7xDependencies.add("lib/jsp-2.0/slf4j-simple-1.0-rc5.jar");
        jetty7xDependencies.add("lib/management/jetty-management.jar");
        jetty7xDependencies.add("lib/management/mx4j-3.0.1.jar");
        jetty7xDependencies.add("lib/management/mx4j-tools-2.1.1.jar");
        jetty7xDependencies.add("lib/naming/jetty-naming.jar");
        jetty7xDependencies.add("lib/plus/jetty-plus.jar");
        jetty7xDependencies.add("lib/xbean/jetty-xbean.jar");
        this.jettyDependencies.put("jetty4x", jetty4xDependencies);
        this.jettyDependencies.put("jetty5x", jetty5xDependencies);
        this.jettyDependencies.put("jetty6x", jetty6xDependencies);
        this.jettyDependencies.put("jetty7x", jetty7xDependencies);
    }

    public ClassLoader resolveDependencies(String jettyContainerId, File containerHome) throws FileNotFoundException {
        URLClassLoader classloader;
        try {
            List dependencies = (List)this.jettyDependencies.get(jettyContainerId);
            URL[] urls = new URL[dependencies.size() + 1];
            int i = 0;
            Iterator it = dependencies.iterator();
            while (it.hasNext()) {
                String dependencyRelativePath = (String)it.next();
                File dependencyPath = new File(containerHome, dependencyRelativePath);
                urls[i++] = dependencyPath.toURL();
            }
            if (!this.jdkUtils.isOSX()) {
                urls[i++] = this.jdkUtils.getToolsJar().toURL();
            }
            classloader = new URLClassLoader(urls, null);
        }
        catch (MalformedURLException e) {
            throw new CargoException("Failed to resolve dependency", (Throwable)e);
        }
        return classloader;
    }
}

