/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.TreeSet;
import junit.framework.Test;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.generic.deployable.DefaultDeployableFactory;
import org.codehaus.cargo.sample.java.AbstractCargoTestCase;
import org.codehaus.cargo.sample.java.CargoTestSuite;
import org.codehaus.cargo.sample.java.EnvironmentTestData;
import org.codehaus.cargo.sample.java.PingUtils;
import org.codehaus.cargo.sample.java.validator.HasStandaloneConfigurationValidator;
import org.codehaus.cargo.sample.java.validator.HasWarSupportValidator;
import org.codehaus.cargo.sample.java.validator.IsInstalledLocalContainerValidator;
import org.codehaus.cargo.sample.java.validator.StartsWithContainerValidator;
import org.codehaus.cargo.sample.java.validator.Validator;
import org.codehaus.cargo.util.CargoException;
import org.codehaus.cargo.util.log.Logger;

public class WarExtraClasspathTest
extends AbstractCargoTestCase {
    public WarExtraClasspathTest(String testName, EnvironmentTestData testData) throws Exception {
        super(testName, testData);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.setContainer(this.createContainer(this.createConfiguration(ConfigurationType.STANDALONE)));
    }

    public static Test suite() throws Exception {
        CargoTestSuite suite = new CargoTestSuite("Tests that run on local containers to test extra classpath");
        TreeSet<String> excludedContainerIds = new TreeSet<String>();
        excludedContainerIds.add("jetty5x");
        excludedContainerIds.add("tomcat4x");
        excludedContainerIds.add("tomcat5x");
        suite.addTestSuite(WarExtraClasspathTest.class, new Validator[]{new StartsWithContainerValidator(new String[]{"jetty", "tomcat", "liberty"}), new HasWarSupportValidator(), new IsInstalledLocalContainerValidator(), new HasStandaloneConfigurationValidator()}, excludedContainerIds);
        return suite;
    }

    public void testLoadClass() throws MalformedURLException {
        String simpleJar = System.getProperty("cargo.testdata.simple-jar");
        if (simpleJar == null) {
            throw new CargoException("Please set property [cargo.testdata.simple-jar] to a valid location of simple-jar");
        }
        WAR war = (WAR)new DefaultDeployableFactory().createDeployable(this.getContainer().getId(), this.getTestData().getTestDataFileFor("classpath-war"), DeployableType.WAR);
        war.setExtraClasspath(new String[]{simpleJar});
        this.getLocalContainer().getConfiguration().addDeployable((Deployable)war);
        this.getLocalContainer().getConfiguration().setProperty("cargo.tomcat.copywars", "false");
        URL warPingURL = new URL("http://localhost:" + this.getTestData().port + "/classpath-war/test");
        this.getLocalContainer().start();
        PingUtils.assertPingTrue((String)"simple war should have been started at this point", (URL)warPingURL, (Logger)this.getLogger());
        this.getLocalContainer().stop();
        PingUtils.assertPingFalse((String)"simple war should have been stopped at this point", (URL)warPingURL, (Logger)this.getLogger());
    }
}

