/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java.jboss;

import java.util.TreeSet;
import junit.framework.Test;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.generic.deployable.DefaultDeployableFactory;
import org.codehaus.cargo.sample.java.CargoTestSuite;
import org.codehaus.cargo.sample.java.EnvironmentTestData;
import org.codehaus.cargo.sample.java.jboss.AbstractJBossCapabilityTestCase;
import org.codehaus.cargo.sample.java.validator.HasDeployableSupportValidator;
import org.codehaus.cargo.sample.java.validator.HasStandaloneConfigurationValidator;
import org.codehaus.cargo.sample.java.validator.IsInstalledLocalContainerValidator;
import org.codehaus.cargo.sample.java.validator.StartsWithContainerValidator;
import org.codehaus.cargo.sample.java.validator.Validator;
import org.codehaus.cargo.sample.testdata.ejb.Sample;
import org.codehaus.cargo.sample.testdata.ejb.SampleHome;

public class EjbCapabilityContainerTest
extends AbstractJBossCapabilityTestCase {
    public EjbCapabilityContainerTest(String testName, EnvironmentTestData testData) throws Exception {
        super(testName, testData);
    }

    public static Test suite() throws Exception {
        TreeSet<String> excludedContainerIds = new TreeSet<String>();
        excludedContainerIds.add("jboss7x");
        excludedContainerIds.add("jboss71x");
        excludedContainerIds.add("jboss72x");
        excludedContainerIds.add("jboss73x");
        excludedContainerIds.add("jboss74x");
        excludedContainerIds.add("jboss75x");
        CargoTestSuite suite = new CargoTestSuite("Tests that can run on containers supporting EJB deployments");
        suite.addTestSuite(EjbCapabilityContainerTest.class, new Validator[]{new StartsWithContainerValidator(new String[]{"jboss"}), new HasDeployableSupportValidator(DeployableType.EJB), new IsInstalledLocalContainerValidator(), new HasStandaloneConfigurationValidator()}, excludedContainerIds);
        return suite;
    }

    public void testDeployEjbStatically() throws Exception {
        this.setContainer(this.createContainer(this.createConfiguration(ConfigurationType.STANDALONE)));
        Deployable ejb = new DefaultDeployableFactory().createDeployable(this.getContainer().getId(), this.getTestData().getTestDataFileFor("simple-ejb"), DeployableType.EJB);
        this.getLocalContainer().getConfiguration().addDeployable(ejb);
        this.getLocalContainer().start();
        SampleHome home = (SampleHome)this.jndiLookup("SampleEJB");
        Sample sample = home.create();
        EjbCapabilityContainerTest.assertTrue((String)"Should have returned true", (boolean)sample.isWorking());
        this.getLocalContainer().stop();
    }
}

