/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java.jboss;

import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import junit.framework.Test;
import org.codehaus.cargo.container.State;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.generic.deployable.DefaultDeployableFactory;
import org.codehaus.cargo.sample.java.CargoTestSuite;
import org.codehaus.cargo.sample.java.EnvironmentTestData;
import org.codehaus.cargo.sample.java.jboss.AbstractJBossCapabilityTestCase;
import org.codehaus.cargo.sample.java.validator.HasDeployableSupportValidator;
import org.codehaus.cargo.sample.java.validator.HasStandaloneConfigurationValidator;
import org.codehaus.cargo.sample.java.validator.IsInstalledLocalContainerValidator;
import org.codehaus.cargo.sample.java.validator.StartsWithContainerValidator;
import org.codehaus.cargo.sample.java.validator.Validator;

public class HarCapabilityContainerTest
extends AbstractJBossCapabilityTestCase {
    private static final String SIMPLE_HAR_OBJECT_NAME = "cargo.testdata:name=simple-har";

    public HarCapabilityContainerTest(String testName, EnvironmentTestData testData) throws Exception {
        super(testName, testData);
    }

    public static Test suite() throws Exception {
        CargoTestSuite suite = new CargoTestSuite("Test that verifies that deployment of HAR archive work on local installed JBoss containers");
        suite.addTestSuite(HarCapabilityContainerTest.class, new Validator[]{new StartsWithContainerValidator(new String[]{"jboss"}), new HasDeployableSupportValidator(DeployableType.HAR), new IsInstalledLocalContainerValidator(), new HasStandaloneConfigurationValidator()});
        return suite;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.setContainer(this.createContainer(this.createConfiguration(ConfigurationType.STANDALONE)));
    }

    public void testDeployHarStatically() throws Exception {
        Deployable har = new DefaultDeployableFactory().createDeployable(this.getContainer().getId(), this.getTestData().getTestDataFileFor("simple-har"), DeployableType.HAR);
        this.getLocalContainer().getConfiguration().addDeployable(har);
        this.getLocalContainer().start();
        HarCapabilityContainerTest.assertEquals((Object)State.STARTED, (Object)this.getContainer().getState());
        MBeanServerConnection server = this.createMBeanServerConnection();
        ObjectName objectName = ObjectName.getInstance(SIMPLE_HAR_OBJECT_NAME);
        MBeanInfo mbeanInfo = server.getMBeanInfo(objectName);
        this.getLogger().debug("The HAR MBean found: " + mbeanInfo.getDescription(), ((Object)((Object)this)).getClass().getName());
        HarCapabilityContainerTest.assertNotNull((String)"MBean description is null", (Object)mbeanInfo.getDescription());
        this.getLocalContainer().stop();
    }
}

