/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java;

import java.net.MalformedURLException;
import java.util.TreeSet;
import junit.framework.Test;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.configuration.entry.ConfigurationFixtureFactory;
import org.codehaus.cargo.container.configuration.entry.ResourceFixture;
import org.codehaus.cargo.sample.java.AbstractResourceOnStandaloneConfigurationTest;
import org.codehaus.cargo.sample.java.CargoTestSuite;
import org.codehaus.cargo.sample.java.EnvironmentTestData;
import org.codehaus.cargo.sample.java.validator.HasResourceSupportValidator;
import org.codehaus.cargo.sample.java.validator.HasStandaloneConfigurationValidator;
import org.codehaus.cargo.sample.java.validator.HasWarSupportValidator;
import org.codehaus.cargo.sample.java.validator.IsInstalledLocalContainerValidator;
import org.codehaus.cargo.sample.java.validator.Validator;

public class MailResourceOnStandaloneConfigurationTest
extends AbstractResourceOnStandaloneConfigurationTest {
    public MailResourceOnStandaloneConfigurationTest(String testName, EnvironmentTestData testData) throws Exception {
        super(testName, testData);
    }

    @Override
    public Container createContainer(ContainerType type, Configuration configuration) {
        InstalledLocalContainer container = (InstalledLocalContainer)super.createContainer(type, configuration);
        this.addMailJarsToExtraClasspath(container);
        return container;
    }

    private void addMailJarsToExtraClasspath(InstalledLocalContainer container) {
        String mail = System.getProperty("cargo.testdata.mail-jars");
        if (mail != null) {
            String[] jars;
            mail = container.getFileHandler().append(mail, EnvironmentTestData.jakartaEeContainers.contains(container.getId()) ? "jakarta" : "javax");
            for (String jar : jars = container.getFileHandler().getChildren(mail)) {
                container.addExtraClasspath(jar);
            }
        }
    }

    public static Test suite() throws Exception {
        CargoTestSuite suite = new CargoTestSuite("Tests that run on local containers supporting Resource and WAR deployments");
        TreeSet<String> excludedContainerIds = new TreeSet<String>();
        excludedContainerIds.add("glassfish3x");
        excludedContainerIds.add("glassfish4x");
        excludedContainerIds.add("glassfish5x");
        excludedContainerIds.add("glassfish6x");
        excludedContainerIds.add("glassfish7x");
        excludedContainerIds.add("glassfish8x");
        excludedContainerIds.add("payara");
        excludedContainerIds.add("wildfly10x");
        excludedContainerIds.add("wildfly27x");
        excludedContainerIds.add("wildfly28x");
        excludedContainerIds.add("wildfly29x");
        excludedContainerIds.add("wildfly30x");
        excludedContainerIds.add("wildfly31x");
        excludedContainerIds.add("wildfly32x");
        suite.addTestSuite(MailResourceOnStandaloneConfigurationTest.class, new Validator[]{new IsInstalledLocalContainerValidator(), new HasStandaloneConfigurationValidator(), new HasWarSupportValidator(), new HasResourceSupportValidator(ConfigurationType.STANDALONE)}, excludedContainerIds);
        return suite;
    }

    public void testUserConfiguresMailSessionAsResource() throws MalformedURLException {
        ResourceFixture fixture = ConfigurationFixtureFactory.createMailSessionAsResource();
        this.addResourceToConfigurationViaProperty(fixture);
        this.testWar("mailsession");
    }
}

