/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java;

import java.net.MalformedURLException;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.configuration.entry.DataSourceFixture;
import org.codehaus.cargo.sample.java.AbstractWarTestCase;
import org.codehaus.cargo.sample.java.validator.HasDataSourceSupportValidator;
import org.codehaus.cargo.sample.java.validator.IsInstalledLocalContainerValidator;
import org.codehaus.cargo.sample.java.validator.Validator;
import org.codehaus.cargo.util.CargoException;

public abstract class AbstractDataSourceWarCapabilityContainerTestCase
extends AbstractWarTestCase {
    public AbstractDataSourceWarCapabilityContainerTestCase() {
        this.addValidator((Validator)new IsInstalledLocalContainerValidator());
        this.addValidator((Validator)new HasDataSourceSupportValidator(ConfigurationType.STANDALONE));
    }

    @Override
    public Container createContainer(Configuration configuration) {
        InstalledLocalContainer container = (InstalledLocalContainer)super.createContainer(configuration);
        this.setUpDerby(container);
        return container;
    }

    protected void addDataSourceToConfigurationViaProperty(DataSourceFixture fixture) {
        LocalConfiguration config = this.getLocalContainer().getConfiguration();
        config.setProperty("cargo.datasource.datasource", fixture.buildDataSourcePropertyString());
    }

    private void setUpDerby(InstalledLocalContainer container) {
        if (("glassfish3x".equals(container.getId()) || "glassfish4x".equals(container.getId()) || "glassfish5x".equals(container.getId()) || "glassfish6x".equals(container.getId()) || "glassfish7x".equals(container.getId()) || "glassfish8x".equals(container.getId()) || "payara".equals(container.getId())) && !container.getName().startsWith("GlassFish 6.0") && !container.getName().startsWith("Payara 5.2") && !container.getName().startsWith("Payara 6.") && !container.getName().startsWith("Payara 7.")) {
            return;
        }
        String jdbcdriver = System.getProperty("cargo.testdata.derby-jar");
        if (jdbcdriver == null) {
            throw new CargoException("Please set property [cargo.testdata.derby-jar] to a valid location of derby.jar");
        }
        container.addExtraClasspath(jdbcdriver);
        container.getSystemProperties().put("derby.system.home", this.getTestData().configurationHome);
        container.getSystemProperties().put("derby.stream.error.logSeverityLevel", "0");
    }

    protected void testServletThatIssuesGetConnectionFrom(DataSourceFixture fixture, String type) throws MalformedURLException {
        this.addDataSourceToConfigurationViaProperty(fixture);
        if ("datasource-cmt-local".equals(type)) {
            this.testWar(type, "all good!");
        } else if ("datasource".equals(type)) {
            this.testWar(type, "Got DataSource connection!");
        } else if ("xadatasource".equals(type)) {
            this.testWar(type, "Got XADataSource connection!");
        } else {
            this.testWar(type, "Got DataSource connections!");
        }
    }
}

