/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java;

import java.lang.reflect.Method;
import java.net.URL;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.sample.java.AbstractWarTestCase;
import org.codehaus.cargo.sample.java.CargoTestCase;

public abstract class AbstractWarCapabilityContainerTestCase
extends AbstractWarTestCase {
    @Override
    public boolean isSupported(String containerId, ContainerType containerType, Method testMethod) {
        if (!super.isSupported(containerId, containerType, testMethod)) {
            return false;
        }
        return testMethod == null || !"testStartWithOneExpandedWarDeployed".equals(testMethod.getName()) || !containerId.startsWith("geronimo");
    }

    @CargoTestCase
    public void testDeployWarStatically() throws Exception {
        this.testWar("simple", "Sample page for testing");
    }

    @CargoTestCase
    public void testStartWithOneExpandedWarDeployed() throws Exception {
        String expandedWarDirectory = this.getFileHandler().append(this.getFileHandler().getParent(this.getTestData().configurationHome), "expanded-war");
        this.getFileHandler().explode(this.getTestData().getTestDataFileFor("expanded-war"), expandedWarDirectory);
        WAR war = (WAR)this.createDeployable(expandedWarDirectory, DeployableType.WAR);
        this.getLocalContainer().getConfiguration().addDeployable((Deployable)war);
        URL warPingURL = new URL("http://localhost:" + this.getTestData().port + "/expanded-war/index.html");
        this.startAndStop(warPingURL, "Sample page for testing");
    }
}

