/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java;

import java.net.MalformedURLException;
import java.net.URL;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.sample.java.AbstractStandaloneLocalContainerTestCase;
import org.codehaus.cargo.sample.java.PingUtils;
import org.codehaus.cargo.sample.java.validator.HasWarSupportValidator;
import org.codehaus.cargo.sample.java.validator.Validator;
import org.codehaus.cargo.util.log.Logger;

public abstract class AbstractWarTestCase
extends AbstractStandaloneLocalContainerTestCase {
    public AbstractWarTestCase() {
        this.addValidator((Validator)new HasWarSupportValidator());
    }

    protected void testWar(String type, String expectedMessage) throws MalformedURLException {
        WAR war = (WAR)this.createDeployableFromTestdataFile(type + "-war", DeployableType.WAR);
        String page = "simple".equals(type) ? "index.jsp" : "test";
        LocalConfiguration configuration = this.getLocalContainer().getConfiguration();
        configuration.addDeployable((Deployable)war);
        URL warPingURL = new URL(configuration.getPropertyValue("cargo.protocol") + "://localhost:" + this.getTestData().port + "/" + type + "-war/" + page);
        this.startAndStop(warPingURL, expectedMessage);
    }

    protected void startAndStop(URL warPingURL, String expectedMessage) {
        this.getLocalContainer().start();
        PingUtils.assertPingTrue((String)(warPingURL.getPath() + " not started"), (String)expectedMessage, (URL)warPingURL, (Logger)this.getLogger());
        this.getLocalContainer().stop();
        PingUtils.assertPingFalse((String)(warPingURL.getPath() + " not stopped"), (URL)warPingURL, (Logger)this.getLogger());
    }
}

