/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java;

import java.lang.reflect.Method;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.State;
import org.codehaus.cargo.sample.java.AbstractStandaloneLocalContainerTestCase;
import org.codehaus.cargo.sample.java.CargoTestCase;
import org.junit.jupiter.api.Assertions;

public class AllStandaloneLocalContainerTest
extends AbstractStandaloneLocalContainerTestCase {
    @Override
    public boolean isSupported(String containerId, ContainerType containerType, Method testMethod) {
        if (!super.isSupported(containerId, containerType, testMethod)) {
            return false;
        }
        if (testMethod != null && "testRestartWithNoDeployable".equals(testMethod.getName())) {
            if ("glassfish4x".equals(containerId)) {
                return false;
            }
            if ("jonas4x".equals(containerId)) {
                return false;
            }
            if (ContainerType.EMBEDDED.equals((Object)containerType) && containerId.startsWith("jetty")) {
                return false;
            }
        }
        return true;
    }

    @CargoTestCase
    public void testStartWithNoDeployable() throws Exception {
        this.getLocalContainer().start();
        Assertions.assertEquals((Object)State.STARTED, (Object)this.getContainer().getState());
        try {
            this.getLocalContainer().start();
            Assertions.fail((String)"the second start attempt did not fail");
        }
        catch (ContainerException expected) {
            Assertions.assertTrue((boolean)expected.getMessage().contains("restart"), (String)(expected.getMessage() + " does not contain the word 'restart'"));
        }
        this.getLocalContainer().stop();
        Assertions.assertEquals((Object)State.STOPPED, (Object)this.getContainer().getState());
    }

    @CargoTestCase
    public void testRestartWithNoDeployable() throws Exception {
        this.getLocalContainer().start();
        Assertions.assertEquals((Object)State.STARTED, (Object)this.getContainer().getState());
        this.getLocalContainer().restart();
        Assertions.assertEquals((Object)State.STARTED, (Object)this.getContainer().getState());
        this.getLocalContainer().stop();
        Assertions.assertEquals((Object)State.STOPPED, (Object)this.getContainer().getState());
        this.getLocalContainer().restart();
        Assertions.assertEquals((Object)State.STARTED, (Object)this.getContainer().getState());
        this.getLocalContainer().stop();
        Assertions.assertEquals((Object)State.STOPPED, (Object)this.getContainer().getState());
    }
}

