/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import org.codehaus.cargo.container.State;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployer.Deployer;
import org.codehaus.cargo.sample.java.AbstractStandaloneLocalContainerTestCase;
import org.codehaus.cargo.sample.java.CargoTestCase;
import org.codehaus.cargo.sample.java.validator.HasBundleSupportValidator;
import org.codehaus.cargo.sample.java.validator.Validator;
import org.junit.jupiter.api.Assertions;

public class BundleCapabilityContainerTest
extends AbstractStandaloneLocalContainerTestCase {
    public BundleCapabilityContainerTest() {
        this.addValidator((Validator)new HasBundleSupportValidator());
    }

    @CargoTestCase
    public void testStartWithBundleDeployed() throws Exception {
        String targetFile = System.getProperty("cargo.samples.bundle.targetFile");
        Assertions.assertTrue((targetFile != null && !targetFile.isEmpty() ? 1 : 0) != 0, (String)"cargo.samples.bundle.targetFile not set!");
        File bundleOutput = new File(targetFile);
        if (bundleOutput.exists()) {
            bundleOutput.delete();
            Assertions.assertFalse((boolean)bundleOutput.exists(), (String)("Cannot delete " + bundleOutput));
        }
        Deployable bundle = this.createDeployableFromTestdataFile("simple-bundle", DeployableType.BUNDLE);
        this.getLocalContainer().getConfiguration().addDeployable(bundle);
        this.getInstalledLocalContainer().getSystemProperties().put("cargo.samples.bundle.targetFile", targetFile);
        this.getLocalContainer().start();
        Assertions.assertEquals((Object)State.STARTED, (Object)this.getContainer().getState());
        long timeout = System.currentTimeMillis() + 30000L;
        while (!bundleOutput.isFile() && System.currentTimeMillis() < timeout) {
            Thread.sleep(1000L);
        }
        Assertions.assertTrue((boolean)bundleOutput.isFile(), (String)(bundleOutput + " does not exist!"));
        BufferedReader reader = new BufferedReader(new FileReader(bundleOutput));
        Assertions.assertEquals((Object)"Hello, World", (Object)reader.readLine());
        reader.close();
        reader = null;
        System.gc();
        if (this.getTestData().containerId.startsWith("geronimo")) {
            Deployer deployer = this.createDeployer(this.getContainer());
            deployer.undeploy(bundle);
        }
        this.getLocalContainer().stop();
        Assertions.assertEquals((Object)State.STOPPED, (Object)this.getContainer().getState());
        reader = new BufferedReader(new FileReader(bundleOutput));
        Assertions.assertEquals((Object)"Goodbye, World", (Object)reader.readLine());
        reader.close();
        reader = null;
        System.gc();
    }
}

