/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java;

import java.io.File;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Stream;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.generic.DefaultContainerFactory;
import org.codehaus.cargo.sample.java.AbstractCargoTestCase;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContextProvider;

@Target(value={ElementType.METHOD})
@Retention(value=RetentionPolicy.RUNTIME)
@TestTemplate
@ExtendWith(value={CargoTestcaseInvocationContextProvider.class})
public @interface CargoTestCase {

    public static class CargoTestcaseInvocationContextProvider
    implements TestTemplateInvocationContextProvider {
        public static final String SYSTEM_PROPERTY_CONTAINER_IDS = "cargo.containers";
        private Map<String, Set<ContainerType>> registeredContainers = new DefaultContainerFactory().getContainerIds();
        private List<String> containerIds = new ArrayList<String>();

        public CargoTestcaseInvocationContextProvider() {
            if (System.getProperty(SYSTEM_PROPERTY_CONTAINER_IDS) == null) {
                throw new IllegalArgumentException("System property \"cargo.containers\" must be defined.");
            }
            StringTokenizer tokens = new StringTokenizer(System.getProperty(SYSTEM_PROPERTY_CONTAINER_IDS), ",");
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken().trim();
                if (!this.registeredContainers.containsKey(token)) {
                    throw new IllegalArgumentException("Invalid container id: " + token);
                }
                this.containerIds.add(token);
            }
        }

        public boolean supportsTestTemplate(ExtensionContext context) {
            return true;
        }

        public Stream<TestTemplateInvocationContext> provideTestTemplateInvocationContexts(ExtensionContext context) {
            AbstractCargoTestCase testCase;
            if (!AbstractCargoTestCase.class.isAssignableFrom((Class)context.getTestClass().get())) {
                throw new IllegalArgumentException("Not an AbstractCargoTestCase: " + context.getTestClass().get());
            }
            if (context.getTestInstance().isPresent()) {
                testCase = (AbstractCargoTestCase)context.getTestInstance().get();
            } else {
                try {
                    testCase = (AbstractCargoTestCase)((Class)context.getTestClass().get()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Throwable t) {
                    throw new IllegalArgumentException(t);
                }
            }
            File currentJavaHomeDirectory = null;
            String currentJavaHome = System.getProperty("java.home");
            if (currentJavaHome != null && !currentJavaHome.isEmpty()) {
                currentJavaHomeDirectory = new File(currentJavaHome).getAbsoluteFile();
            }
            ArrayList<CargoTestcaseInvocationContext> invocationContexts = new ArrayList<CargoTestcaseInvocationContext>();
            for (String containerid : this.containerIds) {
                for (ContainerType containerType : this.registeredContainers.get(containerid)) {
                    File containerJavaHomeDirectory;
                    String containerJavaHome;
                    if (containerType.equals((Object)ContainerType.EMBEDDED) && (containerJavaHome = System.getProperty("cargo." + containerid + ".java.home")) != null && !containerJavaHome.isEmpty() && !currentJavaHomeDirectory.equals(containerJavaHomeDirectory = new File(containerJavaHome).getAbsoluteFile()) || !testCase.isSupported(containerid, containerType, (Method)context.getTestMethod().get())) continue;
                    invocationContexts.add(new CargoTestcaseInvocationContext(containerid, containerType));
                }
            }
            Assumptions.assumeFalse((boolean)invocationContexts.isEmpty(), (String)"None of the contaier ids support the requested test");
            return invocationContexts.stream();
        }
    }

    public static class CargoTestcaseInvocationContext
    implements TestTemplateInvocationContext {
        private String containerId;
        private ContainerType containerType;

        public CargoTestcaseInvocationContext(String containerId, ContainerType containerType) {
            this.containerId = containerId;
            this.containerType = containerType;
        }

        public String getContainerId() {
            return this.containerId;
        }

        public ContainerType getContainerType() {
            return this.containerType;
        }

        public List<Extension> getAdditionalExtensions() {
            return Arrays.asList(this.preProcessor());
        }

        public String getDisplayName(int invocationIndex) {
            return this.containerId + "," + this.containerType.getType();
        }

        private BeforeTestExecutionCallback preProcessor() {
            return new BeforeTestExecutionCallback(){

                public void beforeTestExecution(ExtensionContext context) throws Exception {
                    ((AbstractCargoTestCase)context.getTestInstance().get()).setUp(this, context);
                }
            };
        }
    }
}

