/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java;

import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.sample.java.AbstractStandaloneLocalContainerTestCase;
import org.codehaus.cargo.sample.java.CargoTestCase;
import org.codehaus.cargo.sample.java.PingUtils;
import org.codehaus.cargo.sample.java.validator.HasWarSupportValidator;
import org.codehaus.cargo.sample.java.validator.IsInstalledLocalContainerValidator;
import org.codehaus.cargo.sample.java.validator.Validator;
import org.codehaus.cargo.util.CargoException;
import org.codehaus.cargo.util.log.Logger;

public class ExtraClasspathOnStandaloneConfigurationTest
extends AbstractStandaloneLocalContainerTestCase {
    public ExtraClasspathOnStandaloneConfigurationTest() {
        this.addValidator((Validator)new HasWarSupportValidator());
        this.addValidator((Validator)new IsInstalledLocalContainerValidator());
    }

    @Override
    public boolean isSupported(String containerId, ContainerType containerType, Method testMethod) {
        if (!super.isSupported(containerId, containerType, testMethod)) {
            return false;
        }
        return !"geronimo1x".equals(containerId);
    }

    @CargoTestCase
    public void testLoadClass() throws MalformedURLException {
        WAR war = (WAR)this.createDeployableFromTestdataFile("classpath-war", DeployableType.WAR);
        this.getLocalContainer().getConfiguration().addDeployable((Deployable)war);
        URL warPingURL = new URL("http://localhost:" + this.getTestData().port + "/classpath-war/test");
        this.getLocalContainer().start();
        PingUtils.assertPingTrue((String)"classpath war should have been started at this point", (String)"Got class!", (URL)warPingURL, (Logger)this.getLogger());
        this.getLocalContainer().stop();
        PingUtils.assertPingFalse((String)"classpath war should have been stopped at this point", (URL)warPingURL, (Logger)this.getLogger());
    }

    @Override
    public Container createContainer(Configuration configuration) {
        InstalledLocalContainer container = (InstalledLocalContainer)super.createContainer(configuration);
        String simpleJar = System.getProperty("cargo.testdata.simple-jar");
        if (simpleJar == null) {
            throw new CargoException("Please set property [cargo.testdata.simple-jar] to a valid location of simple-jar");
        }
        container.addExtraClasspath(simpleJar);
        return container;
    }
}

