/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java;

import java.lang.reflect.Method;
import java.net.MalformedURLException;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.configuration.entry.ConfigurationFixtureFactory;
import org.codehaus.cargo.container.configuration.entry.ResourceFixture;
import org.codehaus.cargo.sample.java.AbstractResourceOnStandaloneConfigurationTest;
import org.codehaus.cargo.sample.java.CargoTestCase;
import org.codehaus.cargo.sample.java.EnvironmentTestData;
import org.codehaus.cargo.sample.java.validator.HasResourceSupportValidator;
import org.codehaus.cargo.sample.java.validator.IsInstalledLocalContainerValidator;
import org.codehaus.cargo.sample.java.validator.Validator;
import org.junit.jupiter.api.extension.ExtensionContext;

public class JmsTopicResourceOnStandaloneConfigurationTest
extends AbstractResourceOnStandaloneConfigurationTest {
    public JmsTopicResourceOnStandaloneConfigurationTest() {
        this.addValidator((Validator)new HasResourceSupportValidator(ConfigurationType.STANDALONE));
        this.addValidator((Validator)new IsInstalledLocalContainerValidator());
    }

    @Override
    public boolean isSupported(String containerId, ContainerType containerType, Method testMethod) {
        if (!super.isSupported(containerId, containerType, testMethod)) {
            return false;
        }
        if (containerId.startsWith("wildfly") && EnvironmentTestData.jakartaEeContainers.contains(containerId)) {
            return false;
        }
        if (containerId.startsWith("resin")) {
            return false;
        }
        if (containerId.startsWith("tomcat")) {
            return false;
        }
        return this.isNotContained(containerId, "jboss75x", "weblogic121x", "weblogic122x", "weblogic14x", "wildfly10x");
    }

    @Override
    public void setUp(CargoTestCase.CargoTestcaseInvocationContext cargoContext, ExtensionContext testContext) throws Exception {
        super.setUp(cargoContext, testContext);
        if (this.getTestData().containerId.startsWith("wildfly")) {
            this.getLocalContainer().getConfiguration().setProperty("cargo.jboss.configuration", "standalone-full");
            if (this.getTestData().containerId.equals("wildfly9x")) {
                this.getLocalContainer().getConfiguration().setProperty("cargo.wildfly.script.cli.embedded.journal", "target/test-classes/wildfly/wildfly9/jms-journal.cli");
            } else {
                this.getLocalContainer().getConfiguration().setProperty("cargo.wildfly.script.cli.embedded.journal", "target/test-classes/wildfly/wildfly/jms-journal.cli");
            }
        }
    }

    @CargoTestCase
    public void testUserConfiguresJmsTopicAsResource() throws MalformedURLException {
        ResourceFixture fixture = ConfigurationFixtureFactory.createJmsTopicAsResource();
        this.addResourceToConfigurationViaProperty(fixture);
        this.testWar("jms-topic", "Got JMS topic!");
    }
}

