/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java;

import java.net.URL;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.sample.java.AbstractStandaloneLocalContainerTestCase;
import org.codehaus.cargo.sample.java.CargoTestCase;
import org.codehaus.cargo.sample.java.PingUtils;
import org.codehaus.cargo.sample.java.validator.HasPortOffsetValidator;
import org.codehaus.cargo.sample.java.validator.HasWarSupportValidator;
import org.codehaus.cargo.sample.java.validator.Validator;
import org.codehaus.cargo.util.log.Logger;

public class PortOffsetContainerTest
extends AbstractStandaloneLocalContainerTestCase {
    private static final String OFFSET = "20";

    public PortOffsetContainerTest() {
        this.addValidator((Validator)new HasWarSupportValidator());
        this.addValidator((Validator)new HasPortOffsetValidator(ConfigurationType.STANDALONE));
    }

    @CargoTestCase
    public void testStartWithPortOffset() throws Exception {
        this.getLocalContainer().getConfiguration().setProperty("cargo.port.offset", OFFSET);
        int offsetValue = Integer.valueOf(OFFSET);
        int portWithOffset = this.getTestData().port + offsetValue;
        WAR war = (WAR)this.createDeployableFromTestdataFile("simple-war", DeployableType.WAR);
        this.getLocalContainer().getConfiguration().addDeployable((Deployable)war);
        URL warPingURL = new URL("http://localhost:" + portWithOffset + "/simple-war/index.jsp");
        this.getLocalContainer().start();
        PingUtils.assertPingTrue((String)(warPingURL.getPath() + " not started"), (String)"Sample page for testing", (URL)warPingURL, (Logger)this.getLogger());
        this.getLocalContainer().stop();
        PingUtils.assertPingFalse((String)(warPingURL.getPath() + " not stopped"), (URL)warPingURL, (Logger)this.getLogger());
    }
}

