/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java;

import java.net.URL;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.sample.java.AbstractStandaloneLocalContainerTestCase;
import org.codehaus.cargo.sample.java.CargoTestCase;
import org.codehaus.cargo.sample.java.PingUtils;
import org.codehaus.cargo.sample.java.validator.HasSpawnSupportValidator;
import org.codehaus.cargo.sample.java.validator.HasWarSupportValidator;
import org.codehaus.cargo.sample.java.validator.Validator;
import org.codehaus.cargo.util.log.Logger;

public class SpawnContainerTest
extends AbstractStandaloneLocalContainerTestCase {
    public SpawnContainerTest() {
        this.addValidator((Validator)new HasWarSupportValidator());
        this.addValidator((Validator)new HasSpawnSupportValidator(ConfigurationType.STANDALONE));
    }

    @CargoTestCase
    public void testStartSpawned() throws Exception {
        this.getLocalContainer().getConfiguration().setProperty("cargo.process.spawn", "true");
        this.getLocalContainer().setOutput(null);
        WAR war = (WAR)this.createDeployableFromTestdataFile("simple-war", DeployableType.WAR);
        this.getLocalContainer().getConfiguration().addDeployable((Deployable)war);
        URL pingURL = new URL("http://localhost:" + this.getTestData().port + "/simple-war/index.jsp");
        this.getLocalContainer().start();
        PingUtils.assertPingTrue((String)(pingURL.getPath() + " not started"), (String)"Sample page for testing", (URL)pingURL, (Logger)this.getLogger());
        this.getLocalContainer().stop();
        PingUtils.assertPingFalse((String)(pingURL.getPath() + " not stopped"), (URL)pingURL, (Logger)this.getLogger());
    }
}

