/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java;

import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.property.User;
import org.codehaus.cargo.sample.java.AbstractStandaloneLocalContainerTestCase;
import org.codehaus.cargo.sample.java.CargoTestCase;
import org.codehaus.cargo.sample.java.PingUtils;
import org.codehaus.cargo.sample.java.validator.HasWarSupportValidator;
import org.codehaus.cargo.sample.java.validator.SupportsPropertyValidator;
import org.codehaus.cargo.sample.java.validator.Validator;
import org.codehaus.cargo.util.log.Logger;

public class WarAuthenticationTest
extends AbstractStandaloneLocalContainerTestCase {
    public WarAuthenticationTest() {
        this.addValidator((Validator)new HasWarSupportValidator());
        this.addValidator((Validator)new SupportsPropertyValidator(ConfigurationType.STANDALONE, "cargo.servlet.users"));
    }

    @CargoTestCase
    public void testExecutionWithAuthenticatedWar() throws Exception {
        WAR war = (WAR)this.createDeployableFromTestdataFile("authentication-war", DeployableType.WAR);
        this.getLocalContainer().getConfiguration().addDeployable((Deployable)war);
        List users = User.parseUsers((String)"someone:p@ssw0rd:cargo");
        this.getLocalContainer().getConfiguration().getUsers().addAll(users);
        URL warPingURL = new URL("http://localhost:" + this.getTestData().port + "/authentication-war/test");
        this.getLocalContainer().start();
        HashMap<String, String> requestProperties = new HashMap<String, String>();
        requestProperties.put("Authorization", "Basic " + Base64.getEncoder().encodeToString("someone:p@ssw0rd".getBytes(StandardCharsets.UTF_8)));
        PingUtils.assertPingTrue((String)"Failed authentication", (String)"Principal name [someone], Is user in \"cargo\" role [true]", (URL)warPingURL, requestProperties, (Logger)this.getLogger());
        this.getLocalContainer().stop();
        PingUtils.assertPingFalse((String)"Authentication war not stopped", (URL)warPingURL, (Logger)this.getLogger());
    }
}

