/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java;

import java.net.URL;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.deployer.DeployableMonitor;
import org.codehaus.cargo.container.deployer.Deployer;
import org.codehaus.cargo.container.deployer.URLDeployableMonitor;
import org.codehaus.cargo.sample.java.AbstractStandaloneLocalContainerTestCase;
import org.codehaus.cargo.sample.java.CargoTestCase;
import org.codehaus.cargo.sample.java.PingUtils;
import org.codehaus.cargo.sample.java.validator.HasLocalDeployerValidator;
import org.codehaus.cargo.sample.java.validator.HasWarSupportValidator;
import org.codehaus.cargo.sample.java.validator.Validator;
import org.codehaus.cargo.util.log.Logger;

public class WarDeployerCapabilityContainerTest
extends AbstractStandaloneLocalContainerTestCase {
    public WarDeployerCapabilityContainerTest() {
        this.addValidator((Validator)new HasWarSupportValidator());
        this.addValidator((Validator)new HasLocalDeployerValidator());
    }

    @CargoTestCase
    public void testWarHotDeployment() throws Exception {
        if ("jetty12x".equals(this.getTestData().containerId)) {
            this.getLocalContainer().getConfiguration().setProperty("cargo.jvmargs", "-Djetty.deploy.scanInterval=1");
        }
        WAR war = (WAR)this.createDeployableFromTestdataFile("simple-war", DeployableType.WAR);
        war.setContext("simple");
        URL warPingURL = new URL("http://localhost:" + this.getTestData().port + "/" + war.getContext() + "/index.jsp");
        this.getLocalContainer().start();
        if (!this.getLocalContainer().getName().startsWith("Payara 7.2025.1.Alpha")) {
            PingUtils.assertPingFalse((String)"simple war should not be present at this point", (URL)warPingURL, (Logger)this.getLogger());
        }
        Deployer deployer = this.createDeployer(this.getContainer());
        URLDeployableMonitor deployableMonitor = new URLDeployableMonitor(warPingURL);
        deployableMonitor.setLogger(this.getLogger());
        deployer.deploy((Deployable)war, (DeployableMonitor)deployableMonitor);
        PingUtils.assertPingTrue((String)"simple war should have been deployed at this point", (String)"Sample page for testing", (URL)warPingURL, (Logger)this.getLogger());
        String containerId = this.getContainer().getId();
        if (this.isNotContained(containerId, "jetty6x", "jetty7x", "jetty8x", "jetty9x", "jetty10x", "jetty11x", "jetty12x", "jo1x", "liberty", "resin3x", "resin4x", "resin31x") && !this.getLocalContainer().getName().startsWith("Payara 7.2025.1.Alpha") && !this.getContainer().getType().equals((Object)ContainerType.EMBEDDED) && this.isNotContained(containerId, "tomcat8x", "tomcat9x", "tomcat10x", "tomcat11x")) {
            deployer.undeploy((Deployable)war, (DeployableMonitor)deployableMonitor);
            PingUtils.assertPingFalse((String)"simple war should have been undeployed at this point", (URL)warPingURL, (Logger)this.getLogger());
        }
        this.getLocalContainer().stop();
    }
}

