/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java;

import java.lang.reflect.Method;
import java.net.URL;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.sample.java.AbstractStandaloneLocalContainerTestCase;
import org.codehaus.cargo.sample.java.CargoTestCase;
import org.codehaus.cargo.sample.java.PingUtils;
import org.codehaus.cargo.sample.java.validator.HasWarSupportValidator;
import org.codehaus.cargo.sample.java.validator.Validator;
import org.codehaus.cargo.util.log.Logger;

public class WarRootContextTest
extends AbstractStandaloneLocalContainerTestCase {
    public WarRootContextTest() {
        this.addValidator((Validator)new HasWarSupportValidator());
    }

    @Override
    public boolean isSupported(String containerId, ContainerType containerType, Method testMethod) {
        if (!super.isSupported(containerId, containerType, testMethod)) {
            return false;
        }
        return this.isNotContained(containerId, "geronimo1x", "geronimo2x", "geronimo3x", "glassfish2x", "jo1x", "jonas4x", "jonas5x", "weblogic8x", "weblogic9x", "weblogic10x", "weblogic103x", "weblogic12x", "weblogic121x", "weblogic122x", "weblogic14x");
    }

    @CargoTestCase
    public void testDeployWarDefinedWithRootPath() throws Exception {
        WAR war = (WAR)this.createDeployableFromTestdataFile("simple-war", DeployableType.WAR);
        war.setContext("/");
        this.getLocalContainer().getConfiguration().addDeployable((Deployable)war);
        URL warPingURL = new URL("http://localhost:" + this.getTestData().port + "/index.jsp");
        this.getLocalContainer().start();
        PingUtils.assertPingTrue((String)(warPingURL.getPath() + " not started"), (String)"Sample page for testing", (URL)warPingURL, (Logger)this.getLogger());
        this.getLocalContainer().stop();
        PingUtils.assertPingFalse((String)(warPingURL.getPath() + " not stopped"), (URL)warPingURL, (Logger)this.getLogger());
    }
}

