/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java.jetty;

import java.util.List;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.sample.java.AbstractWarTestCase;
import org.codehaus.cargo.sample.java.EmbeddedContainerClasspathResolver;
import org.codehaus.cargo.sample.java.validator.IsEmbeddedLocalContainerValidator;
import org.codehaus.cargo.sample.java.validator.StartsWithContainerValidator;
import org.codehaus.cargo.sample.java.validator.SupportsPropertyValidator;
import org.codehaus.cargo.sample.java.validator.Validator;

public abstract class AbstractJettyEmbeddedEEProfileTest
extends AbstractWarTestCase {
    private EmbeddedContainerClasspathResolver resolver;

    public AbstractJettyEmbeddedEEProfileTest(String jettyEeVersion) {
        this.addValidator((Validator)new IsEmbeddedLocalContainerValidator());
        this.addValidator((Validator)new StartsWithContainerValidator(new String[]{"jetty"}));
        this.addValidator((Validator)new SupportsPropertyValidator(ConfigurationType.STANDALONE, "cargo.jetty.deployer.ee.version"));
        this.resolver = new JettyEESpecificEmbeddedContainerClasspathResolver(this, jettyEeVersion);
    }

    @Override
    protected EmbeddedContainerClasspathResolver getEmbeddedContainerClasspathResolver() {
        return this.resolver;
    }

    public abstract List<String> filterDependencies(List<String> var1);

    private static class JettyEESpecificEmbeddedContainerClasspathResolver
    extends EmbeddedContainerClasspathResolver {
        private AbstractJettyEmbeddedEEProfileTest test;
        private String jettyEeVersion;

        public JettyEESpecificEmbeddedContainerClasspathResolver(AbstractJettyEmbeddedEEProfileTest test, String jettyEeVersion) {
            this.test = test;
            this.jettyEeVersion = jettyEeVersion;
        }

        protected List<String> getDependencies(String containerId) {
            List dependencies = super.getDependencies(containerId);
            String[] dependenciesCopy = dependencies.toArray(new String[dependencies.size()]);
            for (int i = 0; i < dependenciesCopy.length; ++i) {
                if (!dependenciesCopy[i].contains("ee10-")) continue;
                dependencies.set(i, dependenciesCopy[i].replace("ee10-", this.jettyEeVersion + "-"));
            }
            return this.test.filterDependencies(dependencies);
        }
    }
}

