/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java;

import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.EmbeddedLocalContainer;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.RemoteContainer;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployer.Deployer;
import org.codehaus.cargo.container.deployer.DeployerType;
import org.codehaus.cargo.container.installer.Proxy;
import org.codehaus.cargo.container.installer.ZipURLInstaller;
import org.codehaus.cargo.container.property.LoggingLevel;
import org.codehaus.cargo.container.tomcat.internal.AbstractCatalinaEmbeddedLocalContainer;
import org.codehaus.cargo.generic.ContainerFactory;
import org.codehaus.cargo.generic.DefaultContainerFactory;
import org.codehaus.cargo.generic.configuration.ConfigurationFactory;
import org.codehaus.cargo.generic.configuration.DefaultConfigurationFactory;
import org.codehaus.cargo.generic.deployable.DefaultDeployableFactory;
import org.codehaus.cargo.generic.deployable.DeployableFactory;
import org.codehaus.cargo.generic.deployer.DefaultDeployerFactory;
import org.codehaus.cargo.generic.deployer.DeployerFactory;
import org.codehaus.cargo.sample.java.CargoTestCase;
import org.codehaus.cargo.sample.java.EmbeddedContainerClasspathResolver;
import org.codehaus.cargo.sample.java.EnvironmentTestData;
import org.codehaus.cargo.sample.java.validator.Validator;
import org.codehaus.cargo.util.DefaultFileHandler;
import org.codehaus.cargo.util.FileHandler;
import org.codehaus.cargo.util.log.FileLogger;
import org.codehaus.cargo.util.log.LogLevel;
import org.codehaus.cargo.util.log.Logger;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.ExtensionContext;

public abstract class AbstractCargoTestCase {
    private static final ContainerFactory CONTAINER_FACTORY = new DefaultContainerFactory();
    private static final ConfigurationFactory CONFIGURATION_FACTORY = new DefaultConfigurationFactory();
    private static final DeployerFactory DEPLOYER_FACTORY = new DefaultDeployerFactory();
    private static final DeployableFactory DEPLOYABLE_FACTORY = new DefaultDeployableFactory();
    private String name = this.getClass().getName();
    private List<Validator> validators = new ArrayList<Validator>();
    private Container container;
    private EnvironmentTestData testData;
    private Logger logger;
    private FileHandler fileHandler;
    private ClassLoader classLoader;

    protected void addValidator(Validator validator) {
        this.validators.add(validator);
    }

    protected boolean isNotContained(String toCheck, String ... checkAgainst) {
        for (String checkAgainstString : checkAgainst) {
            if (!toCheck.equals(checkAgainstString)) continue;
            return false;
        }
        return true;
    }

    public boolean isSupported(String containerId, ContainerType containerType, Method testMethod) {
        for (Validator validator : this.validators) {
            if (validator.validate(containerId, containerType)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.name;
    }

    public void setUp(CargoTestCase.CargoTestcaseInvocationContext cargoContext, ExtensionContext testContext) throws Exception {
        String containerId = cargoContext.getContainerId();
        ContainerType containerType = cargoContext.getContainerType();
        this.name = this.getClass().getName() + " (" + containerId + "," + containerType + ")";
        String targetDirSuffix = containerId + "/" + containerType.getType() + "/" + this.getClass().getSimpleName() + "/" + ((Method)testContext.getTestMethod().get()).getName() + "/container";
        this.testData = new EnvironmentTestData(containerId, containerType, targetDirSuffix);
        File targetDir = new File(this.testData.configurationHome);
        if (targetDir.exists()) {
            String configurationHomeNoSlash = this.testData.configurationHome;
            while (configurationHomeNoSlash.endsWith("/")) {
                configurationHomeNoSlash = configurationHomeNoSlash.substring(0, configurationHomeNoSlash.length() - 1);
            }
            targetDir.renameTo(new File(configurationHomeNoSlash + "-renamed-" + System.currentTimeMillis()));
        }
        targetDir.mkdirs();
        if (!targetDir.isDirectory()) {
            Assertions.fail((String)("Directory " + targetDir + " does not exist"));
        }
        this.logger = new FileLogger(new File(targetDir.getParentFile(), "cargo.log"), true);
        this.logger.setLevel(LogLevel.DEBUG);
        this.fileHandler = new DefaultFileHandler();
        this.fileHandler.setLogger(this.logger);
        if (this.getTestData().containerType == ContainerType.EMBEDDED) {
            EmbeddedContainerClasspathResolver resolver = this.getEmbeddedContainerClasspathResolver();
            try {
                this.classLoader = resolver.resolveDependencies(this.testData.containerId, this.installContainer());
            }
            catch (FileNotFoundException e) {
                Assertions.fail((String)"Cannot create embedded container classloader", (Throwable)e);
            }
            if (this.classLoader != null) {
                Thread.currentThread().setContextClassLoader(this.classLoader);
            }
        }
        this.getLogger().info("Initialised test [" + this.toString() + "]", this.getClass().getName());
    }

    @AfterEach
    protected void tearDown() {
        LocalContainer container;
        if (this.getTestData().containerType == ContainerType.EMBEDDED) {
            Thread.currentThread().setContextClassLoader(null);
        }
        if (this.container != null && this.container.getType().isLocal() && !(container = (LocalContainer)this.container).getState().isStopped()) {
            this.getLogger().info("Container is in the [" + container.getState() + "] state, shutting it down now", this.getClass().getName());
            try {
                container.stop();
            }
            catch (Throwable t) {
                Assertions.fail((String)("Exception stopping container at end of tests: " + t), (Throwable)t);
            }
        }
        this.getLogger().info("Ended test [" + this.toString() + "]", this.getClass().getName());
    }

    protected void setContainer(Container container) {
        this.container = container;
    }

    protected LocalContainer getLocalContainer() {
        return (LocalContainer)this.container;
    }

    protected InstalledLocalContainer getInstalledLocalContainer() {
        return (InstalledLocalContainer)this.container;
    }

    protected RemoteContainer getRemoteContainer() {
        return (RemoteContainer)this.container;
    }

    protected Container getContainer() {
        return this.container;
    }

    protected Deployable createDeployable(String deployablePath, DeployableType deployableType) {
        return DEPLOYABLE_FACTORY.createDeployable(this.testData.containerId, deployablePath, deployableType);
    }

    protected Deployable createDeployableFromTestdataFile(String testDataFile, DeployableType deployableType) {
        return this.createDeployable(this.getTestData().getTestDataFileFor(testDataFile), deployableType);
    }

    protected Deployer createDeployer(DeployerType type, Container container) {
        Deployer deployer = DEPLOYER_FACTORY.createDeployer(container, type);
        deployer.setLogger(this.getLogger());
        return deployer;
    }

    protected Deployer createDeployer(Container container) {
        Deployer deployer = DEPLOYER_FACTORY.createDeployer(container);
        deployer.setLogger(this.getLogger());
        return deployer;
    }

    protected Configuration createConfiguration(ConfigurationType type) {
        return this.createConfiguration(type, this.getTestData().configurationHome);
    }

    protected Configuration createConfiguration(ConfigurationType type, String targetDir) {
        Configuration configuration = type != ConfigurationType.RUNTIME ? CONFIGURATION_FACTORY.createConfiguration(this.getTestData().containerId, this.getTestData().containerType, type, targetDir) : CONFIGURATION_FACTORY.createConfiguration(this.getTestData().containerId, this.getTestData().containerType, type);
        configuration.setProperty("cargo.servlet.port", "" + this.getTestData().port);
        configuration.setProperty("cargo.rmi.port", "" + this.getTestData().rmiPort);
        Properties allProperties = System.getProperties();
        for (Map.Entry<Object, Object> property : allProperties.entrySet()) {
            if (property.getKey() == null || property.getValue() == null) continue;
            String key = property.getKey().toString().replace("cargo.samples.", "cargo.");
            if (!configuration.getCapability().supportsProperty(key)) continue;
            configuration.setProperty(key, property.getValue().toString());
        }
        if (this.getTestData().javaHome != null && !this.getTestData().javaHome.isEmpty()) {
            configuration.setProperty("cargo.java.home", this.getTestData().javaHome);
        }
        configuration.setProperty("cargo.logging", LoggingLevel.HIGH.getLevel());
        configuration.setLogger(this.getLogger());
        if (this.getTestData().containerId.startsWith("wildfly-swarm")) {
            configuration.setProperty("cargo.swarm.hollowswarm", "true");
        }
        return configuration;
    }

    protected Container createContainer(Configuration configuration) {
        return this.createContainer(this.getTestData().containerType, configuration);
    }

    protected Container createContainer(ContainerType type, Configuration configuration) {
        Container container = CONTAINER_FACTORY.createContainer(this.getTestData().containerId, type, configuration);
        container.setLogger(this.getLogger());
        if (container.getType().isLocal()) {
            this.setUpLocalSettings(configuration, (LocalContainer)container);
        }
        return container;
    }

    protected EnvironmentTestData getTestData() {
        return this.testData;
    }

    protected Logger getLogger() {
        return this.logger;
    }

    protected FileHandler getFileHandler() {
        return this.fileHandler;
    }

    protected EmbeddedContainerClasspathResolver getEmbeddedContainerClasspathResolver() {
        return new EmbeddedContainerClasspathResolver();
    }

    private void setUpLocalSettings(Configuration configuration, LocalContainer container) {
        if (container.getType() == ContainerType.EMBEDDED) {
            ((EmbeddedLocalContainer)container).setClassLoader(this.classLoader);
            if (container instanceof AbstractCatalinaEmbeddedLocalContainer) {
                configuration.setProperty("cargo.tomcat.embedded.overrideJavaLogging", "true");
            }
        } else if (container.getType() == ContainerType.INSTALLED) {
            this.setUpHome((InstalledLocalContainer)container);
            this.setUpClover((InstalledLocalContainer)container);
        }
        File logFile = new File(new File(this.getTestData().configurationHome).getParentFile(), "output.log");
        logFile.delete();
        container.setOutput(logFile.getPath());
        container.setTimeout(this.getTestData().containerTimeout);
    }

    private void setUpClover(InstalledLocalContainer container) {
        if (System.getProperty("cargo.clover.jar") != null) {
            container.addExtraClasspath(System.getProperty("cargo.clover.jar"));
            if (System.getProperty("cargo.clover.license") != null) {
                System.setProperty("clover.license.path", System.getProperty("cargo.clover.license"));
            }
        }
    }

    private void setUpHome(InstalledLocalContainer container) {
        if (this.getTestData().containerHome != null) {
            container.setHome(this.getTestData().containerHome);
        } else if (this.getTestData().installURL != null) {
            container.setHome(this.installContainer());
        }
    }

    private String installContainer() {
        ZipURLInstaller installer = new ZipURLInstaller(this.getTestData().installURL, this.getTestData().downloadDir, this.getTestData().extractDir);
        installer.setLogger(this.getLogger());
        if (this.getTestData().proxy != null) {
            Proxy userProxy = this.getTestData().proxy;
            userProxy.setLogger(this.getLogger());
            installer.setProxy(userProxy);
        }
        installer.install();
        return installer.getHome();
    }
}

