/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java;

import java.lang.reflect.Method;
import java.net.MalformedURLException;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.configuration.entry.ConfigurationFixtureFactory;
import org.codehaus.cargo.container.configuration.entry.DataSourceFixture;
import org.codehaus.cargo.sample.java.AbstractDataSourceWarCapabilityContainerTestCase;
import org.codehaus.cargo.sample.java.CargoTestCase;

public class DataSourceOnStandaloneConfigurationTest
extends AbstractDataSourceWarCapabilityContainerTestCase {
    @Override
    public boolean isSupported(String containerId, ContainerType containerType, Method testMethod) {
        if (!super.isSupported(containerId, containerType, testMethod)) {
            return false;
        }
        return this.isNotContained(containerId, "geronimo2x", "liberty");
    }

    @CargoTestCase
    public void testUserConfiguresDriverAndRequestsDataSource() throws MalformedURLException {
        DataSourceFixture fixture = ConfigurationFixtureFactory.createDataSource();
        if ("glassfish4x".equals(this.getTestData().containerId)) {
            fixture.jndiLocation = "jdbc/__default";
        }
        this.testServletThatIssuesGetConnectionFrom(fixture, "datasource");
    }

    @CargoTestCase
    public void testMultipleDataSources() throws MalformedURLException {
        DataSourceFixture fixture = ConfigurationFixtureFactory.createDataSource();
        if ("glassfish4x".equals(this.getTestData().containerId)) {
            fixture.jndiLocation = "jdbc/__default";
        }
        LocalConfiguration config = this.getLocalContainer().getConfiguration();
        config.setProperty("cargo.datasource.datasource.1", fixture.buildDataSourcePropertyString());
        fixture = ConfigurationFixtureFactory.createAnotherDataSource();
        this.testServletThatIssuesGetConnectionFrom(fixture, "two-datasources");
    }
}

