/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java;

import java.lang.reflect.Method;
import java.net.URL;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployable.EAR;
import org.codehaus.cargo.container.deployer.DeployableMonitor;
import org.codehaus.cargo.container.deployer.Deployer;
import org.codehaus.cargo.container.deployer.URLDeployableMonitor;
import org.codehaus.cargo.container.internal.util.HttpUtils;
import org.codehaus.cargo.sample.java.AbstractStandaloneLocalContainerTestCase;
import org.codehaus.cargo.sample.java.CargoTestCase;
import org.codehaus.cargo.sample.java.PingUtils;
import org.codehaus.cargo.sample.java.validator.HasEarSupportValidator;
import org.codehaus.cargo.sample.java.validator.HasLocalDeployerValidator;
import org.codehaus.cargo.sample.java.validator.Validator;
import org.codehaus.cargo.util.log.Logger;
import org.junit.jupiter.api.Assertions;

public class EarDeployerCapabilityContainerTest
extends AbstractStandaloneLocalContainerTestCase {
    public EarDeployerCapabilityContainerTest() {
        this.addValidator((Validator)new HasEarSupportValidator());
        this.addValidator((Validator)new HasLocalDeployerValidator());
    }

    @Override
    public boolean isSupported(String containerId, ContainerType containerType, Method testMethod) {
        if (!super.isSupported(containerId, containerType, testMethod)) {
            return false;
        }
        return this.isNotContained(containerId, "liberty", "tomee1x", "tomee7x", "tomee8x", "tomee9x", "tomee10x", "weblogic122x", "weblogic14x");
    }

    @CargoTestCase
    public void testEarHotDeployment() throws Exception {
        Deployable ear = this.createDeployableFromTestdataFile("simple-ear", DeployableType.EAR);
        ((EAR)ear).setName("ear-test-CARGO-1641");
        URL earPingURL = new URL("http://localhost:" + this.getTestData().port + "/simpleweb/index.jsp");
        this.getLocalContainer().start();
        if (this.getLocalContainer().getName().startsWith("Payara 7")) {
            HttpUtils httpUtils = new HttpUtils();
            httpUtils.setLogger(this.getLogger());
            HttpUtils.HttpResult result = new HttpUtils.HttpResult();
            httpUtils.ping(earPingURL, null, result, 20000L);
            Assertions.assertEquals((Object)"", (Object)result.responseBody, (String)"simple ear should not be present at this point");
        } else {
            PingUtils.assertPingFalse((String)"simple ear should not be present at this point", (URL)earPingURL, (Logger)this.getLogger());
        }
        Deployer deployer = this.createDeployer(this.getContainer());
        URLDeployableMonitor deployableMonitor = new URLDeployableMonitor(earPingURL);
        deployableMonitor.setLogger(this.getLogger());
        deployer.deploy(ear, (DeployableMonitor)deployableMonitor);
        PingUtils.assertPingTrue((String)"simple ear should have been deployed at this point", (String)"Sample page for testing", (URL)earPingURL, (Logger)this.getLogger());
        if (this.getLocalContainer().getName().startsWith("Payara 7")) {
            deployer.undeploy(ear);
            HttpUtils httpUtils = new HttpUtils();
            httpUtils.setLogger(this.getLogger());
            HttpUtils.HttpResult result = new HttpUtils.HttpResult();
            httpUtils.ping(earPingURL, null, result, 20000L);
            Assertions.assertEquals((Object)"", (Object)result.responseBody, (String)"simple ear not correctly undeployed");
        } else {
            deployer.undeploy(ear, (DeployableMonitor)deployableMonitor);
            PingUtils.assertPingFalse((String)"simple ear not correctly undeployed", (URL)earPingURL, (Logger)this.getLogger());
        }
        this.getLocalContainer().stop();
    }
}

