/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.configuration.FileConfig;
import org.codehaus.cargo.sample.java.AbstractWarCapabilityContainerTestCase;
import org.codehaus.cargo.sample.java.CargoTestCase;
import org.codehaus.cargo.sample.java.PingUtils;
import org.codehaus.cargo.sample.java.validator.HasExistingConfigurationValidator;
import org.codehaus.cargo.sample.java.validator.Validator;
import org.codehaus.cargo.util.log.Logger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.ExtensionContext;

public class ExistingConfigurationTest
extends AbstractWarCapabilityContainerTestCase {
    public ExistingConfigurationTest() {
        this.addValidator((Validator)new HasExistingConfigurationValidator());
    }

    @Override
    public boolean isSupported(String containerId, ContainerType containerType, Method testMethod) {
        if (!super.isSupported(containerId, containerType, testMethod)) {
            return false;
        }
        return testMethod == null || !"testStartWithOneExpandedWarDeployed".equals(testMethod.getName()) || !"weblogic12x".equals(containerId);
    }

    @Override
    public void setUp(CargoTestCase.CargoTestcaseInvocationContext cargoContext, ExtensionContext testContext) throws Exception {
        super.setUp(cargoContext, testContext);
        LocalContainer tmpContainer = (LocalContainer)this.createContainer(this.createConfiguration(ConfigurationType.STANDALONE));
        tmpContainer.getConfiguration().configure(tmpContainer);
        this.setContainer(this.createContainer(this.createConfiguration(ConfigurationType.EXISTING)));
    }

    @Override
    public void startAndStop(URL warPingURL, String expectedMessage) {
        String testFileName = "cargo-test/test.file";
        File testFile = new File(this.getLocalContainer().getConfiguration().getHome(), testFileName);
        Assertions.assertFalse((boolean)testFile.exists(), (String)("File " + testFile + " already exists"));
        FileConfig fileConfig = new FileConfig();
        fileConfig.setFile(this.getTestData().getTestDataFileFor("simple-war"));
        fileConfig.setToFile(testFileName);
        this.getLocalContainer().getConfiguration().setConfigFileProperty(fileConfig);
        this.getLocalContainer().start();
        PingUtils.assertPingTrue((String)(warPingURL.getPath() + " not started"), (String)expectedMessage, (URL)warPingURL, (Logger)this.getLogger());
        Assertions.assertTrue((boolean)testFile.exists(), (String)("File " + testFile + " was not configured"));
        this.getLocalContainer().stop();
        PingUtils.assertPingFalse((String)(warPingURL.getPath() + " not stopped"), (URL)warPingURL, (Logger)this.getLogger());
    }
}

