/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java;

import java.lang.reflect.Method;
import java.net.MalformedURLException;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.configuration.entry.ConfigurationFixtureFactory;
import org.codehaus.cargo.container.configuration.entry.ResourceFixture;
import org.codehaus.cargo.sample.java.AbstractResourceOnStandaloneConfigurationTest;
import org.codehaus.cargo.sample.java.CargoTestCase;
import org.codehaus.cargo.sample.java.EnvironmentTestData;
import org.codehaus.cargo.sample.java.validator.HasResourceSupportValidator;
import org.codehaus.cargo.sample.java.validator.IsInstalledLocalContainerValidator;
import org.codehaus.cargo.sample.java.validator.Validator;

public class MailResourceOnStandaloneConfigurationTest
extends AbstractResourceOnStandaloneConfigurationTest {
    public MailResourceOnStandaloneConfigurationTest() {
        this.addValidator((Validator)new HasResourceSupportValidator(ConfigurationType.STANDALONE));
        this.addValidator((Validator)new IsInstalledLocalContainerValidator());
    }

    @Override
    public boolean isSupported(String containerId, ContainerType containerType, Method testMethod) {
        if (!super.isSupported(containerId, containerType, testMethod)) {
            return false;
        }
        if (containerId.startsWith("wildfly") && EnvironmentTestData.jakartaEeContainers.contains(containerId)) {
            return false;
        }
        return this.isNotContained(containerId, "glassfish3x", "glassfish4x", "glassfish5x", "glassfish6x", "glassfish7x", "glassfish8x", "payara");
    }

    @Override
    public Container createContainer(ContainerType type, Configuration configuration) {
        return this.addMailJarsToExtraClasspath((InstalledLocalContainer)super.createContainer(type, configuration));
    }

    private Container addMailJarsToExtraClasspath(InstalledLocalContainer container) {
        String mail = System.getProperty("cargo.testdata.mail-jars");
        if (mail != null) {
            String[] jars;
            mail = container.getFileHandler().append(mail, EnvironmentTestData.jakartaEeContainers.contains(container.getId()) ? "jakarta" : "javax");
            for (String jar : jars = container.getFileHandler().getChildren(mail)) {
                container.addExtraClasspath(jar);
            }
        }
        return container;
    }

    @CargoTestCase
    public void testUserConfiguresMailSessionAsResource() throws MalformedURLException {
        ResourceFixture fixture = ConfigurationFixtureFactory.createMailSessionAsResource();
        this.addResourceToConfigurationViaProperty(fixture);
        this.testWar("mailsession", "Got mail session!");
    }
}

