/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java;

import java.io.File;
import java.net.URL;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.packager.Packager;
import org.codehaus.cargo.container.packager.PackagerType;
import org.codehaus.cargo.container.spi.packager.AbstractDirectoryPackager;
import org.codehaus.cargo.generic.DefaultContainerFactory;
import org.codehaus.cargo.generic.packager.DefaultPackagerFactory;
import org.codehaus.cargo.sample.java.AbstractStandaloneLocalContainerTestCase;
import org.codehaus.cargo.sample.java.CargoTestCase;
import org.codehaus.cargo.sample.java.PingUtils;
import org.codehaus.cargo.sample.java.validator.HasDirectoryPackagerValidator;
import org.codehaus.cargo.sample.java.validator.IsInstalledLocalContainerValidator;
import org.codehaus.cargo.sample.java.validator.Validator;
import org.codehaus.cargo.util.log.Logger;

public class PackagerTest
extends AbstractStandaloneLocalContainerTestCase {
    public PackagerTest() {
        this.addValidator((Validator)new HasDirectoryPackagerValidator());
        this.addValidator((Validator)new IsInstalledLocalContainerValidator());
    }

    @CargoTestCase
    public void testPackageContainer() throws Exception {
        WAR war = (WAR)this.createDeployableFromTestdataFile("simple-war", DeployableType.WAR);
        this.getLocalContainer().getConfiguration().addDeployable((Deployable)war);
        this.getLocalContainer().getConfiguration().configure(this.getLocalContainer());
        File targetLocation = new File(new File(this.getTestData().configurationHome).getParentFile(), "package");
        DefaultPackagerFactory factory = new DefaultPackagerFactory();
        Packager packager = factory.createPackager(this.getTestData().containerId, PackagerType.DIRECTORY, targetLocation.getPath());
        ((AbstractDirectoryPackager)packager).setLogger(this.getLogger());
        packager.packageContainer(this.getInstalledLocalContainer());
        this.setContainer(new DefaultContainerFactory().createContainer(this.getTestData().containerId, this.getTestData().containerType, this.createConfiguration(ConfigurationType.EXISTING, targetLocation.getPath())));
        this.getLocalContainer().setLogger(this.getLogger());
        this.getInstalledLocalContainer().setHome(targetLocation.getPath());
        URL warPingURL = new URL("http://localhost:" + this.getTestData().port + "/simple-war/index.jsp");
        if (this.getContainer().getName().startsWith("Jetty 9.2.")) {
            return;
        }
        this.getLocalContainer().start();
        PingUtils.assertPingTrue((String)"simple war not started", (String)"Sample page for testing", (URL)warPingURL, (Logger)this.getLogger());
        this.getLocalContainer().stop();
        PingUtils.assertPingFalse((String)"simple war not stopped", (URL)warPingURL, (Logger)this.getLogger());
    }
}

