/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.deployer.Deployer;
import org.codehaus.cargo.container.deployer.DeployerType;
import org.codehaus.cargo.container.internal.util.HttpUtils;
import org.codehaus.cargo.container.property.User;
import org.codehaus.cargo.sample.java.AbstractCargoTestCase;
import org.codehaus.cargo.sample.java.CargoTestCase;
import org.codehaus.cargo.sample.java.EnvironmentTestData;
import org.codehaus.cargo.sample.java.PingUtils;
import org.codehaus.cargo.sample.java.jboss.AbstractJBossCapabilityTestCase;
import org.codehaus.cargo.sample.java.validator.HasInstalledLocalContainerValidator;
import org.codehaus.cargo.sample.java.validator.HasRemoteContainerValidator;
import org.codehaus.cargo.sample.java.validator.HasRemoteDeployerValidator;
import org.codehaus.cargo.sample.java.validator.HasRuntimeConfigurationValidator;
import org.codehaus.cargo.sample.java.validator.HasStandaloneConfigurationValidator;
import org.codehaus.cargo.sample.java.validator.HasWarSupportValidator;
import org.codehaus.cargo.sample.java.validator.Validator;
import org.codehaus.cargo.util.ZipCompressor;
import org.codehaus.cargo.util.log.Logger;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.ExtensionContext;

public class RemoteDeploymentTest
extends AbstractCargoTestCase {
    private InstalledLocalContainer localContainer;
    private Deployer deployer;
    private WAR war;

    public RemoteDeploymentTest() {
        this.addValidator((Validator)new HasRemoteContainerValidator());
        this.addValidator((Validator)new HasRuntimeConfigurationValidator());
        this.addValidator((Validator)new HasRemoteDeployerValidator());
        this.addValidator((Validator)new HasWarSupportValidator());
    }

    @Override
    public void setUp(CargoTestCase.CargoTestcaseInvocationContext cargoContext, ExtensionContext testContext) throws Exception {
        super.setUp(cargoContext, testContext);
        this.setContainer(this.createContainer(this.createConfiguration(ConfigurationType.RUNTIME)));
        this.startLocalContainer();
        ArrayList<File> filesToAddToClasspath = new ArrayList<File>();
        if (this.getTestData().containerId.equals("glassfish3x") || this.getTestData().containerId.equals("glassfish4x") || this.getTestData().containerId.equals("glassfish5x") || this.getTestData().containerId.equals("payara")) {
            for (File jar : new File(this.localContainer.getHome(), "glassfish/modules").listFiles()) {
                if (!jar.isFile()) continue;
                filesToAddToClasspath.add(jar);
            }
        } else if (this.getTestData().containerId.startsWith("jboss")) {
            int jbossVersion = Integer.parseInt(this.getTestData().containerId.substring(5, this.getTestData().containerId.length() - 1));
            if (jbossVersion < 10 && jbossVersion >= 5 || jbossVersion >= 50) {
                if (jbossVersion == 7 || jbossVersion >= 70 || jbossVersion == 8) {
                    AbstractJBossCapabilityTestCase.addAllJars(new File(this.localContainer.getHome(), "modules"), filesToAddToClasspath);
                } else {
                    for (File jar : new File(this.localContainer.getHome(), "lib").listFiles()) {
                        if (!jar.isFile()) continue;
                        filesToAddToClasspath.add(jar);
                    }
                    for (File jar : new File(this.localContainer.getHome(), "common/lib").listFiles()) {
                        if (!jar.isFile()) continue;
                        filesToAddToClasspath.add(jar);
                    }
                }
            }
        } else if (this.getTestData().containerId.startsWith("wildfly")) {
            Thread.sleep(500L);
        }
        URL[] urlsArray = new URL[filesToAddToClasspath.size()];
        for (int i = 0; i < filesToAddToClasspath.size(); ++i) {
            urlsArray[i] = ((File)filesToAddToClasspath.get(i)).toURI().toURL();
        }
        URLClassLoader classLoader = new URLClassLoader(urlsArray, this.getClass().getClassLoader());
        Thread.currentThread().setContextClassLoader(classLoader);
        if (!(this.getTestData().containerId.equals("glassfish3x") || this.getTestData().containerId.equals("glassfish4x") || this.getTestData().containerId.equals("glassfish5x") || this.getTestData().containerId.equals("payara") || this.getTestData().containerId.startsWith("weblogic"))) {
            this.getRemoteContainer().getConfiguration().setProperty("cargo.remote.username", "cargo");
            this.getRemoteContainer().getConfiguration().setProperty("cargo.remote.password", "password");
        } else if (this.getTestData().containerId.startsWith("weblogic")) {
            this.getRemoteContainer().getConfiguration().setProperty("cargo.weblogic.installation.home", this.localContainer.getHome());
        }
        this.war = (WAR)this.createDeployableFromTestdataFile("simple-war", DeployableType.WAR);
        this.deployer = this.createDeployer(DeployerType.REMOTE, (Container)this.getRemoteContainer());
    }

    private void startLocalContainer() throws Exception {
        EnvironmentTestData testData = this.getTestData();
        String message = "You have implemented the Remote container. Please also implement a standalone local container for the CARGO samples to pass.";
        Assertions.assertTrue((boolean)new HasInstalledLocalContainerValidator().validate(this.getTestData().containerId, ContainerType.INSTALLED), (String)"You have implemented the Remote container. Please also implement a standalone local container for the CARGO samples to pass.");
        Assertions.assertTrue((boolean)new HasStandaloneConfigurationValidator().validate(this.getTestData().containerId, ContainerType.INSTALLED), (String)"You have implemented the Remote container. Please also implement a standalone local container for the CARGO samples to pass.");
        ContainerType oldContainerType = this.getTestData().containerType;
        testData.containerType = ContainerType.INSTALLED;
        this.localContainer = (InstalledLocalContainer)this.createContainer(this.createConfiguration(ConfigurationType.STANDALONE));
        testData.containerType = oldContainerType;
        if (this.getTestData().containerId.startsWith("jetty")) {
            WAR jettyDeployerApplication;
            int jettyVersion = Integer.parseInt(this.getTestData().containerId.substring(5, this.getTestData().containerId.length() - 1));
            if (jettyVersion <= 6) {
                jettyDeployerApplication = (WAR)this.createDeployableFromTestdataFile("cargo-jetty-6-deployer", DeployableType.WAR);
            } else if (jettyVersion <= 9) {
                jettyDeployerApplication = (WAR)this.createDeployableFromTestdataFile("cargo-jetty-7-to-jetty-9-deployer", DeployableType.WAR);
            } else if (jettyVersion == 10) {
                jettyDeployerApplication = (WAR)this.createDeployableFromTestdataFile("cargo-jetty-10-deployer", DeployableType.WAR);
            } else if (jettyVersion == 11) {
                jettyDeployerApplication = (WAR)this.createDeployableFromTestdataFile("cargo-jetty-11-deployer", DeployableType.WAR);
            } else {
                throw new IllegalArgumentException("Jetty " + jettyVersion + " not supported");
            }
            this.localContainer.getConfiguration().addDeployable((Deployable)jettyDeployerApplication);
        } else if (this.getTestData().containerId.startsWith("tomcat")) {
            int tomcatVersion = Integer.parseInt(this.getTestData().containerId.substring(6, this.getTestData().containerId.length() - 1));
            if (tomcatVersion < 7) {
                List users = User.parseUsers((String)"cargo:password:manager");
                this.localContainer.getConfiguration().getUsers().addAll(users);
            } else {
                List users = User.parseUsers((String)"cargo:password:manager-script");
                this.localContainer.getConfiguration().getUsers().addAll(users);
            }
        } else if (this.getTestData().containerId.startsWith("tomee")) {
            List users = User.parseUsers((String)"cargo:password:manager-script");
            this.localContainer.getConfiguration().getUsers().addAll(users);
        } else if (this.getTestData().containerId.startsWith("wildfly")) {
            List users = User.parseUsers((String)"cargo:password:admin");
            this.localContainer.getConfiguration().getUsers().addAll(users);
        }
        this.localContainer.start();
    }

    @Override
    @AfterEach
    protected void tearDown() {
        this.setContainer((Container)this.localContainer);
        super.tearDown();
    }

    @CargoTestCase
    public void testDeployUndeployRedeployWarRemotely() throws Exception {
        URL warPingURL = new URL("http://localhost:" + this.getTestData().port + "/simple-war/index.jsp");
        this.deployer.deploy((Deployable)this.war);
        PingUtils.assertPingTrue((String)"simple war not correctly deployed", (String)"Sample page for testing", (URL)warPingURL, (Logger)this.getLogger());
        this.deployer.undeploy((Deployable)this.war);
        if (this.localContainer.getName().startsWith("Payara 7")) {
            HttpUtils httpUtils = new HttpUtils();
            httpUtils.setLogger(this.getLogger());
            HttpUtils.HttpResult result = new HttpUtils.HttpResult();
            httpUtils.ping(warPingURL, null, result, 20000L);
            Assertions.assertEquals((Object)"", (Object)result.responseBody, (String)"simple war not correctly undeployed");
        } else {
            PingUtils.assertPingFalse((String)"simple war not correctly undeployed", (URL)warPingURL, (Logger)this.getLogger());
        }
        this.deployer.deploy((Deployable)this.war);
        PingUtils.assertPingTrue((String)"simple war not correctly redeployed", (String)"Sample page for testing", (URL)warPingURL, (Logger)this.getLogger());
        if (this.localContainer.getName().startsWith("Jetty 7.1.") || this.localContainer.getName().startsWith("Jetty 7.2.")) {
            return;
        }
        if ("jonas4x".equals(this.getTestData().containerId)) {
            return;
        }
        URL newWarPingURL = new URL("http://localhost:" + this.getTestData().port + "/simple-war/some.html");
        PingUtils.assertPingFalse((String)"modified file already in war", (URL)newWarPingURL, (Logger)this.getLogger());
        Deployable modifiedDeployable = this.modifyWar((Deployable)this.war);
        File modifiedWar = new File(modifiedDeployable.getFile());
        if (!modifiedWar.isFile()) {
            throw new FileNotFoundException("Modified WAR \"" + modifiedWar + "\" doesn't exist");
        }
        this.deployer.redeploy(modifiedDeployable);
        PingUtils.assertPingTrue((String)"simple war not correctly redeployed", (String)"It works...", (URL)newWarPingURL, (Logger)this.getLogger());
    }

    @CargoTestCase
    public void testChangeWarContextAndDeployUndeployRemotely() throws Exception {
        this.war.setContext("simple");
        URL warPingURL = new URL("http://localhost:" + this.getTestData().port + "/" + this.war.getContext() + "/index.jsp");
        this.deployer.deploy((Deployable)this.war);
        PingUtils.assertPingTrue((String)"simple war not correctly deployed", (String)"Sample page for testing", (URL)warPingURL, (Logger)this.getLogger());
        this.deployer.undeploy((Deployable)this.war);
        if (this.localContainer.getName().startsWith("Payara 7")) {
            HttpUtils httpUtils = new HttpUtils();
            httpUtils.setLogger(this.getLogger());
            HttpUtils.HttpResult result = new HttpUtils.HttpResult();
            httpUtils.ping(warPingURL, null, result, 20000L);
            Assertions.assertEquals((Object)"", (Object)result.responseBody, (String)"simple war not correctly undeployed");
        } else {
            PingUtils.assertPingFalse((String)"simple war not correctly undeployed", (URL)warPingURL, (Logger)this.getLogger());
        }
    }

    private Deployable modifyWar(Deployable originalDeployable) throws Exception {
        String modifiedWarDirectory = this.getFileHandler().append(this.getFileHandler().getParent(this.getTestData().configurationHome), "modified-war");
        this.getFileHandler().mkdirs(modifiedWarDirectory);
        this.getFileHandler().explode(originalDeployable.getFile(), modifiedWarDirectory);
        String htmlFile = this.getFileHandler().append(modifiedWarDirectory, "some.html");
        this.getFileHandler().writeTextFile(htmlFile, "It works...", StandardCharsets.UTF_8);
        String modifiedWar = this.getFileHandler().append(this.getFileHandler().getParent(this.getTestData().configurationHome), this.getFileHandler().getName(originalDeployable.getFile()));
        ZipCompressor compressor = new ZipCompressor(this.getFileHandler());
        compressor.compress(modifiedWarDirectory, modifiedWar);
        return this.createDeployable(modifiedWar, DeployableType.WAR);
    }
}

