/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java;

import java.net.URL;
import java.util.UUID;
import org.codehaus.cargo.container.State;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.sample.java.AbstractStandaloneLocalContainerTestCase;
import org.codehaus.cargo.sample.java.CargoTestCase;
import org.codehaus.cargo.sample.java.PingUtils;
import org.codehaus.cargo.sample.java.validator.HasWarSupportValidator;
import org.codehaus.cargo.sample.java.validator.IsInstalledLocalContainerValidator;
import org.codehaus.cargo.sample.java.validator.Validator;
import org.codehaus.cargo.util.log.Logger;
import org.junit.jupiter.api.Assertions;

public class SystemPropertyCapabilityTest
extends AbstractStandaloneLocalContainerTestCase {
    public SystemPropertyCapabilityTest() {
        this.addValidator((Validator)new HasWarSupportValidator());
        this.addValidator((Validator)new IsInstalledLocalContainerValidator());
    }

    @CargoTestCase
    public void testSystemProperty() throws Exception {
        String random = UUID.randomUUID().toString();
        WAR war = (WAR)this.createDeployableFromTestdataFile("systemproperty-war", DeployableType.WAR);
        this.getLocalContainer().getConfiguration().addDeployable((Deployable)war);
        URL pingURL = new URL("http://localhost:" + this.getTestData().port + "/systemproperty-war/test?systemPropertyName=random");
        this.getInstalledLocalContainer().getSystemProperties().put("random", random);
        this.getLocalContainer().start();
        Assertions.assertEquals((Object)State.STARTED, (Object)this.getContainer().getState());
        PingUtils.assertPingTrue((String)(pingURL.getPath() + " not started"), (String)random, (URL)pingURL, (Logger)this.getLogger());
        this.getLocalContainer().stop();
        Assertions.assertEquals((Object)State.STOPPED, (Object)this.getContainer().getState());
        PingUtils.assertPingFalse((String)(pingURL.getPath() + " not stopped"), (URL)pingURL, (Logger)this.getLogger());
    }
}

