/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java;

import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.sample.java.AbstractStandaloneLocalContainerTestCase;
import org.codehaus.cargo.sample.java.CargoTestCase;
import org.codehaus.cargo.sample.java.PingUtils;
import org.codehaus.cargo.sample.java.validator.HasWarSupportValidator;
import org.codehaus.cargo.sample.java.validator.IsInstalledLocalContainerValidator;
import org.codehaus.cargo.sample.java.validator.StartsWithContainerValidator;
import org.codehaus.cargo.sample.java.validator.Validator;
import org.codehaus.cargo.util.CargoException;
import org.codehaus.cargo.util.log.Logger;

public class WarExtraClasspathTest
extends AbstractStandaloneLocalContainerTestCase {
    public WarExtraClasspathTest() {
        this.addValidator((Validator)new HasWarSupportValidator());
        this.addValidator((Validator)new IsInstalledLocalContainerValidator());
        this.addValidator((Validator)new StartsWithContainerValidator(new String[]{"jetty", "tomcat", "liberty"}));
    }

    @Override
    public boolean isSupported(String containerId, ContainerType containerType, Method testMethod) {
        if (!super.isSupported(containerId, containerType, testMethod)) {
            return false;
        }
        return this.isNotContained(containerId, "tomcat4x", "tomcat5x");
    }

    @CargoTestCase
    public void testLoadClass() throws MalformedURLException {
        String simpleJar = System.getProperty("cargo.testdata.simple-jar");
        if (simpleJar == null) {
            throw new CargoException("Please set property [cargo.testdata.simple-jar] to a valid location of simple-jar");
        }
        WAR war = (WAR)this.createDeployableFromTestdataFile("classpath-war", DeployableType.WAR);
        war.setExtraClasspath(new String[]{simpleJar});
        this.getLocalContainer().getConfiguration().addDeployable((Deployable)war);
        this.getLocalContainer().getConfiguration().setProperty("cargo.tomcat.copywars", "false");
        URL warPingURL = new URL("http://localhost:" + this.getTestData().port + "/classpath-war/test");
        this.getLocalContainer().start();
        PingUtils.assertPingTrue((String)"classpath war should have been started at this point", (String)"Got class!", (URL)warPingURL, (Logger)this.getLogger());
        this.getLocalContainer().stop();
        PingUtils.assertPingFalse((String)"classpath war should have been stopped at this point", (URL)warPingURL, (Logger)this.getLogger());
    }
}

