/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java;

import java.lang.reflect.Method;
import java.net.URL;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.sample.java.AbstractStandaloneLocalContainerTestCase;
import org.codehaus.cargo.sample.java.CargoTestCase;
import org.codehaus.cargo.sample.java.PingUtils;
import org.codehaus.cargo.sample.java.validator.HasWarSupportValidator;
import org.codehaus.cargo.sample.java.validator.Validator;
import org.codehaus.cargo.util.log.Logger;

public class WarMultiContextTest
extends AbstractStandaloneLocalContainerTestCase {
    public WarMultiContextTest() {
        this.addValidator((Validator)new HasWarSupportValidator());
    }

    @Override
    public boolean isSupported(String containerId, ContainerType containerType, Method testMethod) {
        if (!super.isSupported(containerId, containerType, testMethod)) {
            return false;
        }
        return this.isNotContained(containerId, "jboss3x", "jboss4x", "jboss42x", "jboss5x", "jboss51x", "jboss6x", "jboss61x", "jboss7x", "jboss71x", "jboss72x", "jboss73x", "jboss74x", "jboss75x", "jonas4x", "jonas5x", "jrun4x", "oc4j9x", "oc4j10x", "resin3x", "resin31x", "resin4x", "tomcat4x", "weblogic8x", "weblogic9x", "weblogic10x", "weblogic103x", "weblogic12x", "weblogic121x", "weblogic122x", "weblogic14x", "wildfly8x", "wildfly9x", "wildfly10x", "wildfly11x", "wildfly12x", "wildfly13x", "wildfly14x", "wildfly15x", "wildfly16x", "wildfly17x", "wildfly18x", "wildfly19x", "wildfly20x", "wildfly21x", "wildfly22x", "wildfly23x", "wildfly24x", "wildfly25x", "wildfly26x", "wildfly27x", "wildfly28x", "wildfly29x", "wildfly30x", "wildfly31x", "wildfly32x", "wildfly33x", "wildfly34x", "wildfly35x", "wildfly36x", "wildfly37x");
    }

    @CargoTestCase
    public void testDeployWarDefinedWithMultipleContextPath() throws Exception {
        WAR war = (WAR)this.createDeployableFromTestdataFile("simple-war", DeployableType.WAR);
        war.setContext("/a/b");
        this.getLocalContainer().getConfiguration().addDeployable((Deployable)war);
        URL warPingURL = new URL("http://localhost:" + this.getTestData().port + "/a/b/index.jsp");
        this.getLocalContainer().start();
        PingUtils.assertPingTrue((String)(warPingURL.getPath() + " not started"), (String)"Sample page for testing", (URL)warPingURL, (Logger)this.getLogger());
        this.getLocalContainer().stop();
        PingUtils.assertPingFalse((String)(warPingURL.getPath() + " not stopped"), (URL)warPingURL, (Logger)this.getLogger());
    }
}

