/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java.jboss;

import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.codehaus.cargo.container.State;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.sample.java.CargoTestCase;
import org.codehaus.cargo.sample.java.jboss.AbstractJBossCapabilityTestCase;
import org.codehaus.cargo.sample.java.validator.HasDeployableSupportValidator;
import org.codehaus.cargo.sample.java.validator.Validator;
import org.junit.jupiter.api.Assertions;

public class AopCapabilityContainerTest
extends AbstractJBossCapabilityTestCase {
    private static final String JBOSSAOP_ASPECTMANAGER_OBJECT_NAME = "jboss.aop:service=AspectManager";

    public AopCapabilityContainerTest() {
        this.addValidator((Validator)new HasDeployableSupportValidator(DeployableType.AOP));
    }

    @CargoTestCase
    public void testDeployAopStatically() throws Exception {
        Deployable aop = this.createDeployableFromTestdataFile("simple-aop", DeployableType.AOP);
        this.getLocalContainer().getConfiguration().addDeployable(aop);
        this.getLocalContainer().start();
        Assertions.assertEquals((Object)State.STARTED, (Object)this.getContainer().getState());
        MBeanServerConnection server = this.createMBeanServerConnection();
        ObjectName objectName = ObjectName.getInstance(JBOSSAOP_ASPECTMANAGER_OBJECT_NAME);
        String pointcuts = (String)server.invoke(objectName, "pointcuts", new Object[0], new String[0]);
        this.getLogger().debug("Registered aop pointcuts: " + pointcuts, this.getClass().getName());
        Assertions.assertTrue((boolean)pointcuts.contains("cargoTestDataSimpleAop"), (String)"Dummy cargo aop pointcut not found");
        this.getLocalContainer().stop();
    }
}

