/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java.jboss;

import java.lang.reflect.Method;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.sample.java.CargoTestCase;
import org.codehaus.cargo.sample.java.jboss.AbstractJBossCapabilityTestCase;
import org.codehaus.cargo.sample.java.validator.HasDeployableSupportValidator;
import org.codehaus.cargo.sample.java.validator.StartsWithContainerValidator;
import org.codehaus.cargo.sample.java.validator.Validator;
import org.codehaus.cargo.sample.testdata.ejb.Sample;
import org.codehaus.cargo.sample.testdata.ejb.SampleHome;
import org.junit.jupiter.api.Assertions;

public class EjbCapabilityContainerTest
extends AbstractJBossCapabilityTestCase {
    public EjbCapabilityContainerTest() {
        this.addValidator((Validator)new HasDeployableSupportValidator(DeployableType.EJB));
        this.addValidator((Validator)new StartsWithContainerValidator(new String[]{"jboss"}));
    }

    @Override
    public boolean isSupported(String containerId, ContainerType containerType, Method testMethod) {
        if (!super.isSupported(containerId, containerType, testMethod)) {
            return false;
        }
        return this.isNotContained(containerId, "jboss7x", "jboss71x", "jboss72x", "jboss73x", "jboss74x", "jboss75x");
    }

    @CargoTestCase
    public void testDeployEjbStatically() throws Exception {
        Deployable ejb = this.createDeployableFromTestdataFile("simple-ejb", DeployableType.EJB);
        this.getLocalContainer().getConfiguration().addDeployable(ejb);
        this.getLocalContainer().start();
        SampleHome home = (SampleHome)this.jndiLookup("SampleEJB");
        Sample sample = home.create();
        Assertions.assertTrue((boolean)sample.isWorking(), (String)"Sample EJB not working");
        this.getLocalContainer().stop();
    }
}

