/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java.jboss;

import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.codehaus.cargo.container.State;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.sample.java.CargoTestCase;
import org.codehaus.cargo.sample.java.jboss.AbstractJBossCapabilityTestCase;
import org.codehaus.cargo.sample.java.validator.HasDeployableSupportValidator;
import org.codehaus.cargo.sample.java.validator.Validator;
import org.junit.jupiter.api.Assertions;

public class HarCapabilityContainerTest
extends AbstractJBossCapabilityTestCase {
    private static final String SIMPLE_HAR_OBJECT_NAME = "cargo.testdata:name=simple-har";

    public HarCapabilityContainerTest() {
        this.addValidator((Validator)new HasDeployableSupportValidator(DeployableType.HAR));
    }

    @CargoTestCase
    public void testDeployHarStatically() throws Exception {
        Deployable har = this.createDeployableFromTestdataFile("simple-har", DeployableType.HAR);
        this.getLocalContainer().getConfiguration().addDeployable(har);
        this.getLocalContainer().start();
        Assertions.assertEquals((Object)State.STARTED, (Object)this.getContainer().getState());
        MBeanServerConnection server = this.createMBeanServerConnection();
        ObjectName objectName = ObjectName.getInstance(SIMPLE_HAR_OBJECT_NAME);
        MBeanInfo mbeanInfo = server.getMBeanInfo(objectName);
        this.getLogger().debug("The HAR MBean found: " + mbeanInfo.getDescription(), this.getClass().getName());
        Assertions.assertNotNull((Object)mbeanInfo.getDescription(), (String)"MBean description is null");
        this.getLocalContainer().stop();
    }
}

