/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java.jetty;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.sample.java.CargoTestCase;
import org.codehaus.cargo.sample.java.jetty.AbstractJettyEmbeddedEEProfileTest;

public class JettyEmbeddedEE8ProfileTest
extends AbstractJettyEmbeddedEEProfileTest {
    public JettyEmbeddedEE8ProfileTest() {
        super("ee8");
    }

    @Override
    public List<String> filterDependencies(List<String> dependencies) {
        ArrayList<String> result = new ArrayList<String>();
        for (String dependency : dependencies) {
            if ("lib/jakarta.servlet-api-6.*.jar".equals(dependency)) {
                result.add("lib/jetty-servlet-api-4.*.jar");
                result.add("lib/jetty-ee8-nested-*.jar");
                continue;
            }
            if ("lib/jakarta.transaction-api-2.*.jar".equals(dependency)) {
                result.add("lib/jakarta.transaction-api-1.*.jar");
                continue;
            }
            if ("lib/jetty-security-*.jar".equals(dependency)) {
                result.add("lib/jetty-security-*.jar");
                result.add("lib/jetty-ee8-security-*.jar");
                continue;
            }
            if (dependency.startsWith("lib/jakarta.")) continue;
            result.add(dependency);
        }
        return result;
    }

    @CargoTestCase
    public void testEE8Profile() throws Exception {
        for (Map.Entry testData : new HashMap(this.getTestData().testDataArtifacts).entrySet()) {
            this.getTestData().testDataArtifacts.put((String)testData.getKey(), ((String)testData.getValue()).replace("/deployables-jakarta-ee/", "/deployables/"));
        }
        LocalConfiguration configuration = this.getLocalContainer().getConfiguration();
        configuration.setProperty("cargo.jetty.deployer.ee.version", "ee8");
        this.testWar("simple", "Sample page for testing");
    }
}

