/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java.jetty;

import java.io.File;
import java.net.URL;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.sample.java.AbstractWarTestCase;
import org.codehaus.cargo.sample.java.CargoTestCase;
import org.codehaus.cargo.sample.java.PingUtils;
import org.codehaus.cargo.sample.java.validator.StartsWithContainerValidator;
import org.codehaus.cargo.sample.java.validator.SupportsPropertyValidator;
import org.codehaus.cargo.sample.java.validator.Validator;
import org.codehaus.cargo.util.log.Logger;
import org.junit.jupiter.api.Assertions;

public class JettyTLSTest
extends AbstractWarTestCase {
    public JettyTLSTest() {
        this.addValidator((Validator)new StartsWithContainerValidator(new String[]{"jetty"}));
        this.addValidator((Validator)new SupportsPropertyValidator(ConfigurationType.STANDALONE, "cargo.jetty.connector.https.port"));
    }

    protected void configureHttps() throws Exception {
        File localhostJksFile = new File("target/test-classes/localhost.jks");
        Assertions.assertTrue((boolean)localhostJksFile.isFile());
        LocalConfiguration configuration = this.getLocalContainer().getConfiguration();
        configuration.setProperty("cargo.jetty.connector.keystoreFile", localhostJksFile.getAbsolutePath());
        configuration.setProperty("cargo.jetty.connector.keystorePass", "password");
        configuration.setProperty("cargo.jetty.connector.keystoreType", "jks");
    }

    @CargoTestCase
    public void testJettyWithHttpAndHttps() throws Exception {
        this.configureHttps();
        LocalConfiguration configuration = this.getLocalContainer().getConfiguration();
        configuration.setProperty("cargo.jetty.modules", configuration.getPropertyValue("cargo.jetty.modules").replace("http,", "http,https,"));
        WAR war = (WAR)this.createDeployableFromTestdataFile("simple-war", DeployableType.WAR);
        configuration.addDeployable((Deployable)war);
        URL warHttpPingURL = new URL("http://localhost:" + this.getTestData().port + "/simple-war/index.jsp");
        URL warHttpsPingURL = new URL("https://localhost:" + configuration.getPropertyValue("cargo.jetty.connector.https.port") + "/simple-war/index.jsp");
        this.getLocalContainer().start();
        PingUtils.assertPingTrue((String)"simple war not started on HTTP", (String)"Sample page for testing", (URL)warHttpPingURL, (Logger)this.getLogger());
        PingUtils.assertPingTrue((String)"simple war not started on HTTPS", (String)"Sample page for testing", (URL)warHttpsPingURL, (Logger)this.getLogger());
        this.getLocalContainer().stop();
        PingUtils.assertPingFalse((String)"simple war not stopped on HTTP", (URL)warHttpPingURL, (Logger)this.getLogger());
        PingUtils.assertPingFalse((String)"simple war not stopped on HTTPS", (URL)warHttpsPingURL, (Logger)this.getLogger());
    }

    @CargoTestCase
    public void testJettyWithHttpsOnly() throws Exception {
        this.configureHttps();
        LocalConfiguration configuration = this.getLocalContainer().getConfiguration();
        configuration.setProperty("cargo.jetty.modules", configuration.getPropertyValue("cargo.jetty.modules").replace("http,", "https,"));
        configuration.setProperty("cargo.protocol", "https");
        configuration.setProperty("cargo.jetty.connector.https.port", "" + this.getTestData().port);
        this.testWar("simple", "Sample page for testing");
    }
}

