/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java.jonas;

import java.lang.reflect.Method;
import java.net.URL;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployer.DeployableMonitor;
import org.codehaus.cargo.container.deployer.Deployer;
import org.codehaus.cargo.container.deployer.URLDeployableMonitor;
import org.codehaus.cargo.sample.java.AbstractStandaloneLocalContainerTestCase;
import org.codehaus.cargo.sample.java.CargoTestCase;
import org.codehaus.cargo.sample.java.PingUtils;
import org.codehaus.cargo.sample.java.validator.HasLocalDeployerValidator;
import org.codehaus.cargo.sample.java.validator.StartsWithContainerValidator;
import org.codehaus.cargo.sample.java.validator.Validator;
import org.codehaus.cargo.util.log.Logger;

public class JonasDeploymentPlanTest
extends AbstractStandaloneLocalContainerTestCase {
    public JonasDeploymentPlanTest() {
        this.addValidator((Validator)new StartsWithContainerValidator(new String[]{"jonas"}));
        this.addValidator((Validator)new HasLocalDeployerValidator());
    }

    @Override
    public boolean isSupported(String containerId, ContainerType containerType, Method testMethod) {
        if (!super.isSupported(containerId, containerType, testMethod)) {
            return false;
        }
        return !"jonas4x".equals(containerId);
    }

    @CargoTestCase
    public void testDeploymentPlanHotDeployment() throws Exception {
        this.setContainer(this.createContainer(this.createConfiguration(ConfigurationType.STANDALONE)));
        String urlInternal = this.getFileHandler().createDirectory(this.getInstalledLocalContainer().getHome(), "repositories/url-internal");
        this.getFileHandler().copyFile(this.getTestData().getTestDataFileFor("simple-war"), urlInternal + "/cargo-simple-war.war");
        Deployable deploymentPlan = this.createDeployable("target/test-classes/jonas-deploymentplan.xml", DeployableType.FILE);
        URL warPingURL = new URL("http://localhost:" + this.getTestData().port + "/cargo-simple-war/index.jsp");
        this.getLocalContainer().start();
        PingUtils.assertPingFalse((String)"simple war should not be started at this point", (URL)warPingURL, (Logger)this.getLogger());
        Deployer deployer = this.createDeployer(this.getContainer());
        URLDeployableMonitor deployableMonitor = new URLDeployableMonitor(warPingURL);
        deployableMonitor.setLogger(this.getLogger());
        deployer.deploy(deploymentPlan, (DeployableMonitor)deployableMonitor);
        PingUtils.assertPingTrue((String)"simple war should have been started at this point", (String)"Sample page for testing", (URL)warPingURL, (Logger)this.getLogger());
        deployer.undeploy(deploymentPlan, (DeployableMonitor)deployableMonitor);
        PingUtils.assertPingFalse((String)"simple war should have been stopped at this point", (URL)warPingURL, (Logger)this.getLogger());
        this.getLocalContainer().stop();
    }
}

