/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java.jonas;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.sample.java.AbstractStandaloneLocalContainerTestCase;
import org.codehaus.cargo.sample.java.CargoTestCase;
import org.codehaus.cargo.sample.java.validator.StartsWithContainerValidator;
import org.codehaus.cargo.sample.java.validator.Validator;
import org.junit.jupiter.api.Assertions;

public class JonasStandaloneConfigurationTest
extends AbstractStandaloneLocalContainerTestCase {
    public JonasStandaloneConfigurationTest() {
        this.addValidator((Validator)new StartsWithContainerValidator(new String[]{"jonas"}));
    }

    @CargoTestCase
    public void testConfiguratorProperties() throws Exception {
        System.setProperty("cargo.jonas.configurator.ajpPort", "123456");
        System.setProperty("cargo.jonas.configurator.ajpConnectorActivation", "true");
        this.checkForValue("123456", true);
        System.getProperties().remove("cargo.jonas.configurator.ajpPort");
        System.getProperties().remove("cargo.jonas.configurator.ajpConnectorActivation");
        this.checkForValue("123456", false);
    }

    protected void checkForValue(String check, boolean checkExists) throws Exception {
        this.setContainer(this.createContainer(this.createConfiguration(ConfigurationType.STANDALONE)));
        this.getInstalledLocalContainer().getConfiguration().configure((LocalContainer)this.getInstalledLocalContainer());
        File conf = new File(this.getInstalledLocalContainer().getConfiguration().getHome(), "conf");
        if (!conf.isDirectory()) {
            throw new IllegalArgumentException(conf + " is not a directory");
        }
        ArrayList<Object> serverXmlFiles = new ArrayList<Object>();
        if (this.getTestData().containerId.equals("jonas4x")) {
            serverXmlFiles.add(new File(conf, "server.xml"));
        } else if (this.getTestData().containerId.equals("jonas5x")) {
            for (File confFile : conf.listFiles()) {
                if (!confFile.getName().startsWith("tomcat") || !confFile.getName().endsWith(".xml")) continue;
                serverXmlFiles.add(confFile);
            }
            File deploy = new File(this.getInstalledLocalContainer().getConfiguration().getHome(), "deploy");
            if (deploy.isDirectory()) {
                for (File deployFile : deploy.listFiles()) {
                    if (!deployFile.getName().startsWith("tomcat") || !deployFile.getName().endsWith(".xml")) continue;
                    serverXmlFiles.add(deployFile);
                }
            }
        }
        if (serverXmlFiles.isEmpty()) {
            throw new IllegalArgumentException("Unknown container: " + this.getTestData().containerId);
        }
        for (File file : serverXmlFiles) {
            try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if (checkExists) {
                        if (!line.contains(check)) continue;
                        return;
                    }
                    Assertions.assertTrue((!line.contains(check) ? 1 : 0) != 0, (String)("Line in file " + file + " contains " + check));
                }
            }
        }
        if (checkExists) {
            Assertions.fail((String)("None of the files " + serverXmlFiles + " contains " + check));
        }
    }
}

