/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java.tomcat;

import java.io.File;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.sample.java.AbstractWarTestCase;
import org.codehaus.cargo.sample.java.CargoTestCase;
import org.codehaus.cargo.sample.java.validator.IsInstalledLocalContainerValidator;
import org.codehaus.cargo.sample.java.validator.StartsWithContainerValidator;
import org.codehaus.cargo.sample.java.validator.SupportsPropertyValidator;
import org.codehaus.cargo.sample.java.validator.Validator;
import org.junit.jupiter.api.Assertions;

public class TomcatTLSTest
extends AbstractWarTestCase {
    public TomcatTLSTest() {
        this.addValidator((Validator)new IsInstalledLocalContainerValidator());
        this.addValidator((Validator)new StartsWithContainerValidator(new String[]{"tomcat", "tomee"}));
        this.addValidator((Validator)new SupportsPropertyValidator(ConfigurationType.STANDALONE, "cargo.tomcat.connector.keystoreFile"));
    }

    @CargoTestCase
    public void testTlsConfigContainer() throws Exception {
        File localhostJksFile = new File("target/test-classes/localhost.jks");
        Assertions.assertTrue((boolean)localhostJksFile.isFile());
        LocalConfiguration configuration = this.getLocalContainer().getConfiguration();
        configuration.setProperty("cargo.protocol", "https");
        configuration.setProperty("cargo.tomcat.connector.keystoreFile", localhostJksFile.getAbsolutePath());
        configuration.setProperty("cargo.tomcat.connector.keystorePass", "password");
        this.testWar("simple", "Sample page for testing");
    }
}

