/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java.tomcat;

import java.lang.reflect.Method;
import java.net.URL;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.sample.java.AbstractStandaloneLocalContainerTestCase;
import org.codehaus.cargo.sample.java.CargoTestCase;
import org.codehaus.cargo.sample.java.PingUtils;
import org.codehaus.cargo.sample.java.validator.HasWarSupportValidator;
import org.codehaus.cargo.sample.java.validator.StartsWithContainerValidator;
import org.codehaus.cargo.sample.java.validator.Validator;
import org.codehaus.cargo.util.log.Logger;

public class TomcatWarTest
extends AbstractStandaloneLocalContainerTestCase {
    public TomcatWarTest() {
        this.addValidator((Validator)new HasWarSupportValidator());
        this.addValidator((Validator)new StartsWithContainerValidator(new String[]{"tomcat", "tomee"}));
    }

    @Override
    public boolean isSupported(String containerId, ContainerType containerType, Method testMethod) {
        if (!super.isSupported(containerId, containerType, testMethod)) {
            return false;
        }
        return !"tomcat4x".equals(containerId);
    }

    @CargoTestCase
    public void testWarWithContextXmlFile() throws Exception {
        String artifactFile = this.getFileHandler().append(this.getFileHandler().getParent(this.getTestData().configurationHome), "tomcat-context.war");
        this.getFileHandler().copyFile(this.getTestData().getTestDataFileFor("tomcatcontext-war"), artifactFile);
        WAR war = (WAR)this.createDeployable(artifactFile, DeployableType.WAR);
        this.getLocalContainer().getConfiguration().addDeployable((Deployable)war);
        URL warPingURL = new URL("http://localhost:" + this.getTestData().port + "/tomcat-context/");
        this.getLocalContainer().start();
        PingUtils.assertPingTrue((String)"tomcat context war not started", (String)"Test value is [test value]", (URL)warPingURL, (Logger)this.getLogger());
        this.getLocalContainer().stop();
        PingUtils.assertPingFalse((String)"tomcat context war not stopped", (URL)warPingURL, (Logger)this.getLogger());
    }

    @CargoTestCase
    public void testExpandedWarWithContextXmlFile() throws Exception {
        String expandedWarDirectory = this.getFileHandler().append(this.getFileHandler().getParent(this.getTestData().configurationHome), "tomcat-context");
        this.getFileHandler().explode(this.getTestData().getTestDataFileFor("tomcatcontext-war"), expandedWarDirectory);
        WAR war = (WAR)this.createDeployable(expandedWarDirectory, DeployableType.WAR);
        this.getLocalContainer().getConfiguration().addDeployable((Deployable)war);
        URL warPingURL = new URL("http://localhost:" + this.getTestData().port + "/tomcat-context/");
        this.getLocalContainer().start();
        PingUtils.assertPingTrue((String)"tomcat context war not started", (String)"Test value is [test value]", (URL)warPingURL, (Logger)this.getLogger());
        this.getLocalContainer().stop();
        PingUtils.assertPingFalse((String)"tomcat context war not stopped", (URL)warPingURL, (Logger)this.getLogger());
    }
}

