/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java.tomcat;

import java.lang.reflect.Method;
import java.net.URL;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.sample.java.AbstractStandaloneLocalContainerTestCase;
import org.codehaus.cargo.sample.java.CargoTestCase;
import org.codehaus.cargo.sample.java.PingUtils;
import org.codehaus.cargo.sample.java.validator.HasWarSupportValidator;
import org.codehaus.cargo.sample.java.validator.StartsWithContainerValidator;
import org.codehaus.cargo.sample.java.validator.Validator;
import org.codehaus.cargo.util.CargoException;
import org.codehaus.cargo.util.log.Logger;

public class WarExtraClasspathWithContextTest
extends AbstractStandaloneLocalContainerTestCase {
    private String[] simpleJarExtraClasspath;

    public WarExtraClasspathWithContextTest() {
        this.addValidator((Validator)new HasWarSupportValidator());
        this.addValidator((Validator)new StartsWithContainerValidator(new String[]{"tomcat", "tomee"}));
        String simpleJar = System.getProperty("cargo.testdata.simple-jar");
        if (simpleJar == null) {
            throw new CargoException("Please set property [cargo.testdata.simple-jar] to a valid location of simple-jar");
        }
        this.simpleJarExtraClasspath = new String[]{simpleJar};
    }

    @Override
    public boolean isSupported(String containerId, ContainerType containerType, Method testMethod) {
        if (!super.isSupported(containerId, containerType, testMethod)) {
            return false;
        }
        return this.isNotContained(containerId, "tomcat4x");
    }

    @CargoTestCase
    public void testLoadClassOnWarWithContextXmlFile() throws Exception {
        String artifactFile = this.getFileHandler().append(this.getFileHandler().getParent(this.getTestData().configurationHome), "tomcat-context.war");
        this.getFileHandler().copyFile(this.getTestData().getTestDataFileFor("tomcatcontext-war"), artifactFile);
        WAR war = (WAR)this.createDeployable(artifactFile, DeployableType.WAR);
        this.getLocalContainer().getConfiguration().addDeployable((Deployable)war);
        this.getLocalContainer().getConfiguration().setProperty("cargo.tomcat.copywars", "false");
        URL warPingURL = new URL("http://localhost:" + this.getTestData().port + "/tomcat-context/");
        this.getLocalContainer().start();
        PingUtils.assertPingTrue((String)"tomcat context war not started", (String)"Test value is [test value]", (URL)warPingURL, (Logger)this.getLogger());
        this.getLocalContainer().stop();
        PingUtils.assertPingFalse((String)"tomcat context war not stopped", (URL)warPingURL, (Logger)this.getLogger());
    }

    @CargoTestCase
    public void testLoadClassOnExpandedWarWithContextXmlFile() throws Exception {
        String expandedWarDirectory = this.getFileHandler().append(this.getFileHandler().getParent(this.getTestData().configurationHome), "tomcat-context");
        this.getFileHandler().explode(this.getTestData().getTestDataFileFor("tomcatcontext-war"), expandedWarDirectory);
        WAR war = (WAR)this.createDeployable(expandedWarDirectory, DeployableType.WAR);
        war.setExtraClasspath(this.simpleJarExtraClasspath);
        this.getLocalContainer().getConfiguration().addDeployable((Deployable)war);
        this.getLocalContainer().getConfiguration().setProperty("cargo.tomcat.copywars", "false");
        URL warPingURL = new URL("http://localhost:" + this.getTestData().port + "/tomcat-context/");
        this.getLocalContainer().start();
        PingUtils.assertPingTrue((String)"tomcat context war not started", (String)"Test value is [test value]", (URL)warPingURL, (Logger)this.getLogger());
        this.getLocalContainer().stop();
        PingUtils.assertPingFalse((String)"tomcat context war not stopped", (URL)warPingURL, (Logger)this.getLogger());
    }
}

